/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis.proxy;

import cn.hserver.plugin.mybatis.hook.TxHook;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.InvocationTargetException;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisProxy {
    private static final Logger log = LoggerFactory.getLogger(MybatisProxy.class);
    private static final FastThreadLocal<SqlSession> sqlSessionFastThreadLocal = new FastThreadLocal();
    private static MybatisProxy mybatisProxy;

    public static SqlSession get() {
        return (SqlSession)sqlSessionFastThreadLocal.get();
    }

    private MybatisProxy() {
    }

    public static MybatisProxy getInstance() {
        if (mybatisProxy == null) {
            mybatisProxy = new MybatisProxy();
        }
        return mybatisProxy;
    }

    public Object getProxy(Class clazz, SqlSessionFactory sqlSessionFactory) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (clazz.isInterface()) {
            proxyFactory.setInterfaces(new Class[]{clazz});
        }
        Object o1 = proxyFactory.create(null, null);
        ((ProxyObject)o1).setHandler((self, thisMethod, proceed, args) -> {
            if (sqlSessionFastThreadLocal.get() == null) {
                SqlSession sqlSession = sqlSessionFactory.openSession();
                sqlSessionFastThreadLocal.set((Object)sqlSession);
            }
            Object invoke = null;
            try {
                Object mapper = ((SqlSession)sqlSessionFastThreadLocal.get()).getMapper(clazz);
                thisMethod.setAccessible(true);
                invoke = thisMethod.invoke(mapper, args);
                if (TxHook.ISTX.get() == null || !((Boolean)TxHook.ISTX.get()).booleanValue()) {
                    ((SqlSession)sqlSessionFastThreadLocal.get()).commit();
                }
            }
            catch (Throwable throwable) {
                if (TxHook.ISTX.get() == null || !((Boolean)TxHook.ISTX.get()).booleanValue()) {
                    ((SqlSession)sqlSessionFastThreadLocal.get()).rollback();
                    log.debug("rollback\uff1a" + throwable.getMessage());
                    throw new Exception(throwable);
                }
                throw new Exception(throwable);
            }
            finally {
                if (TxHook.ISTX.get() == null || !((Boolean)TxHook.ISTX.get()).booleanValue()) {
                    ((SqlSession)sqlSessionFastThreadLocal.get()).close();
                    MybatisProxy.removeSession();
                }
            }
            return invoke;
        });
        return o1;
    }

    public static void removeSession() {
        sqlSessionFastThreadLocal.remove();
    }
}

