/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis;

import cn.hserver.core.interfaces.PluginAdapter;
import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.ioc.annotation.Autowired;
import cn.hserver.core.ioc.ref.PackageScanner;
import cn.hserver.plugin.mybatis.MybatisInit;
import cn.hserver.plugin.mybatis.annotation.Mybatis;
import cn.hserver.plugin.mybatis.bean.MybatisConfig;
import cn.hserver.plugin.mybatis.proxy.MybatisProxy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisPlugin
implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlugin.class);
    private Map<String, SqlSessionFactory> stringSqlSessionFactoryMap;

    public void startApp() {
    }

    public void startIocInit() {
    }

    public boolean iocInitBean(Class classz) {
        return false;
    }

    public void iocInit(PackageScanner packageScanner) {
    }

    public void iocInitEnd() {
        HashSet<Class> classes = new HashSet<Class>();
        Map all = IocUtil.getAll();
        all.forEach((k, v) -> {
            if (v instanceof List) {
                List v1 = (List)v;
                for (Object o : v1) {
                    List<Field> objectField = this.getObjectField(o);
                    for (Field declaredField : objectField) {
                        this.mybatisScan(declaredField, classes);
                    }
                }
            } else {
                List<Field> objectField = this.getObjectField(v);
                for (Field declaredField : objectField) {
                    this.mybatisScan(declaredField, classes);
                }
            }
        });
        try {
            this.stringSqlSessionFactoryMap = MybatisInit.initMybatis((MybatisConfig)IocUtil.getBean(MybatisConfig.class), classes);
            if (this.stringSqlSessionFactoryMap == null) {
                return;
            }
            this.stringSqlSessionFactoryMap.forEach(IocUtil::addBean);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void startInjection() {
    }

    public void injectionEnd() {
        if (this.stringSqlSessionFactoryMap == null) {
            return;
        }
        Map all = IocUtil.getAll();
        all.forEach((k, v) -> {
            if (v instanceof List) {
                List v1 = (List)v;
                for (Object o : v1) {
                    List<Field> objectField = this.getObjectField(o);
                    for (Field declaredField : objectField) {
                        this.mybatisConfig(declaredField, o);
                    }
                }
            } else {
                List<Field> objectField = this.getObjectField(v);
                for (Field declaredField : objectField) {
                    this.mybatisConfig(declaredField, v);
                }
            }
        });
        log.info("mybatis\u63d2\u4ef6\u6267\u884c\u5b8c\u6210");
    }

    private void mybatisConfig(Field declaredField, Object v) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            declaredField.setAccessible(true);
            Mybatis mybatis = declaredField.getType().getAnnotation(Mybatis.class);
            try {
                if (mybatis != null) {
                    SqlSessionFactory sqlSessionFactory;
                    String value = mybatis.value();
                    if (value.trim().length() == 0) {
                        value = SqlSessionFactory.class.getName();
                    }
                    if ((sqlSessionFactory = this.stringSqlSessionFactoryMap.get(value)) == null) {
                        log.error("\u6570\u636e\u6e90\u540d\u5b57\uff1a{} \u4e0d\u5b58\u5728", (Object)mybatis.value());
                        return;
                    }
                    Object mapper = MybatisProxy.getInstance().getProxy(declaredField.getType(), sqlSessionFactory);
                    if (declaredField.getType().isAssignableFrom(mapper.getClass())) {
                        declaredField.set(v, mapper);
                        log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{mapper.getClass().getSimpleName(), v.getClass().getSimpleName(), "Mybatis\u6ce8\u5165"});
                    } else {
                        log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:\u7c7b\u578b\u4e0d\u5339\u914d", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef");
                throw new RuntimeException(e);
            }
        }
    }

    private void mybatisScan(Field declaredField, Set<Class> classes) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            declaredField.setAccessible(true);
            Mybatis mybatis = declaredField.getType().getAnnotation(Mybatis.class);
            try {
                if (mybatis != null) {
                    classes.add(declaredField.getType());
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef");
                throw new RuntimeException(e);
            }
        }
    }

    private List<Field> getObjectField(Object clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> aClass = clazz.getClass();
        while (!aClass.equals(Object.class)) {
            Field[] declaredFields = aClass.getDeclaredFields();
            fields.addAll(Arrays.asList(declaredFields));
            aClass = aClass.getSuperclass();
        }
        return fields;
    }
}

