/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mqtt.handlers;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.plugin.mqtt.interfaces.MqttAdapter;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MqttHeartBeatBrokerHandler
extends SimpleChannelInboundHandler<MqttMessage> {
    private static final Logger log = LoggerFactory.getLogger(MqttHeartBeatBrokerHandler.class);
    public static final MqttHeartBeatBrokerHandler INSTANCE = new MqttHeartBeatBrokerHandler();
    private final MqttAdapter mqttAdapter = (MqttAdapter)IocUtil.getSupperBean(MqttAdapter.class);

    private MqttHeartBeatBrokerHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (this.mqttAdapter == null) {
            log.error("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            this.mqttAdapter.channelActive(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.mqttAdapter == null) {
            log.error("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            this.mqttAdapter.channelInactive(ctx);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, MqttMessage mqttMessage) throws Exception {
        if (this.mqttAdapter == null) {
            log.error("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNECT: {
                    this.mqttAdapter.connect(mqttMessage, ctx);
                    break;
                }
                case PINGREQ: {
                    this.mqttAdapter.pingReq(mqttMessage, ctx);
                    break;
                }
                case DISCONNECT: {
                    this.mqttAdapter.disconnect(mqttMessage, ctx);
                    break;
                }
                default: {
                    this.mqttAdapter.message(mqttMessage.fixedHeader().messageType(), mqttMessage, ctx);
                }
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (this.mqttAdapter == null) {
            log.error("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            this.mqttAdapter.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.mqttAdapter == null) {
            log.error("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            this.mqttAdapter.exceptionCaught(ctx, cause);
        }
    }
}

