/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mqtt.handlers;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.plugin.mqtt.interfaces.MqttAdapter;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttMessage;

@ChannelHandler.Sharable
public final class MqttHeartBeatBrokerHandler
extends SimpleChannelInboundHandler<MqttMessage> {
    public static final MqttHeartBeatBrokerHandler INSTANCE = new MqttHeartBeatBrokerHandler();

    private MqttHeartBeatBrokerHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        MqttAdapter bean = (MqttAdapter)IocUtil.getBean(MqttAdapter.class);
        if (bean == null) {
            System.out.println("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            bean.channelActive(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        MqttAdapter bean = (MqttAdapter)IocUtil.getBean(MqttAdapter.class);
        if (bean == null) {
            System.out.println("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            bean.channelInactive(ctx);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, MqttMessage mqttMessage) throws Exception {
        MqttAdapter bean = (MqttAdapter)IocUtil.getBean(MqttAdapter.class);
        if (bean == null) {
            System.out.println("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNECT: {
                    bean.connect(mqttMessage, ctx);
                    break;
                }
                case PINGREQ: {
                    bean.pingReq(mqttMessage, ctx);
                    break;
                }
                case DISCONNECT: {
                    bean.disconnect(mqttMessage, ctx);
                    break;
                }
                default: {
                    bean.message(mqttMessage.fixedHeader().messageType(), mqttMessage, ctx);
                }
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        MqttAdapter bean = (MqttAdapter)IocUtil.getBean(MqttAdapter.class);
        if (bean == null) {
            System.out.println("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            bean.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        MqttAdapter bean = (MqttAdapter)IocUtil.getBean(MqttAdapter.class);
        if (bean == null) {
            System.out.println("\u8bf7\u7ee7\u627fMqttAdapter\u7c7b \u5e76\u7528@Bean \u6807\u8bb0");
        } else {
            bean.exceptionCaught(ctx, cause);
        }
    }
}

