/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import cn.hserver.plugins.maven.JarUtil;
import cn.hserver.plugins.maven.ReBuilderJar;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class RepackageDependenciesMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(property="fatJar", defaultValue="true")
    private String fatJar;
    @Parameter(property="password", defaultValue="")
    private String password;
    private final Log logger = this.getLog();

    public void execute() throws MojoExecutionException {
        try {
            if (JarUtil.alreadyPackage(this.project.getArtifact().getFile())) {
                this.logger.info((CharSequence)"\u5df2\u7ecf\u6253\u5305");
                return;
            }
            long startTime = System.currentTimeMillis();
            this.logger.info((CharSequence)("\u662f\u5426\u80d6\u5305 :" + this.fatJar));
            if (StringUtils.isNotEmpty((CharSequence)this.password)) {
                this.logger.info((CharSequence)("\u52a0\u5bc6\u5bc6\u94a5 :" + this.password));
            }
            String targetPath = this.project.getArtifact().getFile().getParent();
            ReBuilderJar reBuilderJar = new ReBuilderJar(targetPath, this.password, this.fatJar);
            Set<String> dependencies = reBuilderJar.addDependencies(this.project);
            reBuilderJar.addManifest(this.project, dependencies);
            reBuilderJar.addRunner();
            reBuilderJar.close();
            reBuilderJar.rename(this.project);
            this.logger.info((CharSequence)("\u8017\u65f6:" + (System.currentTimeMillis() - startTime) / 1000L + " \u79d2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

