/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import cn.hserver.plugins.maven.JarUtil;
import cn.hserver.runner.Runner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class ReBuilderJar {
    private final JarOutputStream jarOutputStream;
    private final String password;
    private final Boolean fatJar;
    private final String targetPath;
    private final String tempJar = UUID.randomUUID() + ".jar";

    public ReBuilderJar(String targetPath, String password, String fatJar) throws IOException {
        this.targetPath = targetPath;
        this.jarOutputStream = new JarOutputStream(Files.newOutputStream(Paths.get(targetPath + File.separator + this.tempJar, new String[0]), new OpenOption[0]));
        this.password = password;
        this.fatJar = Boolean.parseBoolean(fatJar);
    }

    public Set<String> addDependencies(MavenProject project) throws Exception {
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        Set artifacts = project.getArtifacts();
        for (Artifact dependency : artifacts) {
            File sourceFile = dependency.getFile();
            String lib = "libs/" + sourceFile.getName().trim();
            if (this.fatJar.booleanValue()) {
                JarUtil.addFileToJar(lib, sourceFile, this.jarOutputStream, this.password);
            } else {
                JarUtil.addFileToLibs(this.targetPath + File.separator + lib, sourceFile, this.password);
            }
            dependencies.add(lib);
        }
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        String lib = "libs/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        if (this.fatJar.booleanValue()) {
            JarUtil.addFileToJar(lib, new File(artifactPath), this.jarOutputStream, this.password);
        } else {
            JarUtil.addFileToLibs(this.targetPath + File.separator + lib, new File(artifactPath), this.password);
        }
        dependencies.add(lib);
        return dependencies;
    }

    public void addManifest(MavenProject project, Set<String> dependencies) throws IOException {
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        String mainClassName = JarUtil.getMainClassName(artifactPath);
        this.jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Created-By", "HServer");
        manifest.getMainAttributes().putValue("App-Main-Class", mainClassName);
        if (this.fatJar.booleanValue()) {
            manifest.getMainAttributes().putValue("Type", "true");
        } else {
            manifest.getMainAttributes().putValue("Type", "false");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            manifest.getMainAttributes().putValue("Encrypt", "true");
        } else {
            manifest.getMainAttributes().putValue("Encrypt", "false");
        }
        manifest.getMainAttributes().putValue("Libs", String.join((CharSequence)",", dependencies));
        manifest.getMainAttributes().putValue("Main-Class", "cn.hserver.runner.Runner");
        manifest.getMainAttributes().putValue("Class-Path", ".");
        manifest.write(new BufferedOutputStream(this.jarOutputStream));
    }

    public void copySource(MavenProject project) throws IOException {
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        JarUtil.copyJarEntries(artifactPath, this.jarOutputStream);
    }

    public void addRunner() throws IOException, URISyntaxException {
        String path;
        ProtectionDomain protectionDomain = Runner.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path != null && (path.endsWith(".jar") || path.endsWith(".jar!/"))) {
            String s = path.replaceAll("file:", "").replaceAll("!/", "");
            JarUtil.copyJarEntries(s, this.jarOutputStream);
        }
    }

    public void close() throws IOException {
        this.jarOutputStream.close();
    }

    public void rename(MavenProject project) {
        try {
            File file = project.getArtifact().getFile();
            Path path = Paths.get(this.targetPath + File.separator + file.getName() + ".original", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.move(file.toPath(), path, new CopyOption[0]);
            Files.move(Paths.get(this.targetPath + File.separator + this.tempJar, new String[0]), file.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

