/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import cn.hserver.plugins.maven.AesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javax.crypto.CipherInputStream;
import org.apache.commons.lang3.StringUtils;

public class JarUtil {
    public static boolean alreadyPackage(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttribs = manifest.getMainAttributes();
            String value = mainAttribs.getValue("Created-By");
            if (StringUtils.isNotEmpty((CharSequence)value) && value.equals("HServer")) {
                jarFile.close();
                return true;
            }
            jarFile.close();
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void addFileToLibs(String entryName, File file, String password) throws Exception {
        Path path = Paths.get(entryName, new String[0]);
        Path parent = path.getParent();
        if (!parent.toFile().isDirectory()) {
            parent.toFile().mkdir();
        }
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            CipherInputStream encrypt = AesUtil.encrypt(fileInputStream, password);
            Files.copy(encrypt, path, new CopyOption[0]);
            encrypt.close();
            fileInputStream.close();
        } else {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.copy(file.toPath(), path, new CopyOption[0]);
        }
    }

    public static void addFileToJar(String entryName, File file, JarOutputStream jarOutputStream, String password) throws Exception {
        JarEntry jarEntry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(jarEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            int bytesRead;
            CipherInputStream encrypt = AesUtil.encrypt(fileInputStream, password);
            byte[] buffer = new byte[1024];
            while ((bytesRead = encrypt.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, bytesRead);
            }
            encrypt.close();
        } else {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, bytesRead);
            }
        }
        fileInputStream.close();
        jarOutputStream.closeEntry();
    }

    public static void copyJarEntries(String sourceJarPath, JarOutputStream targetJar) throws IOException {
        try (JarFile sourceJar = new JarFile(sourceJarPath);){
            Enumeration<JarEntry> entries = sourceJar.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().contains("META-INF")) continue;
                JarEntry newEntry = new JarEntry(jarEntry.getName());
                try {
                    targetJar.putNextEntry(newEntry);
                }
                catch (Exception e) {
                    continue;
                }
                InputStream entryInputStream = sourceJar.getInputStream(jarEntry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                    targetJar.write(buffer, 0, bytesRead);
                }
                targetJar.closeEntry();
                entryInputStream.close();
            }
        }
    }

    public static String getMainClassName(String jarPath) throws IOException {
        File f = new File(jarPath);
        URL url1 = f.toURI().toURL();
        URLClassLoader myClassLoader = new URLClassLoader(new URL[]{url1}, Thread.currentThread().getContextClassLoader());
        JarFile jar = new JarFile(jarPath);
        Enumeration<JarEntry> enumFiles = jar.entries();
        ClassPool classPool = ClassPool.getDefault();
        while (enumFiles.hasMoreElements()) {
            JarEntry entry = enumFiles.nextElement();
            String classFullName = entry.getName();
            if (!classFullName.endsWith(".class")) continue;
            try {
                CtMethod[] methods;
                InputStream inputStream = jar.getInputStream(entry);
                CtClass ctClass = classPool.makeClass(inputStream);
                inputStream.close();
                for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
                    if (!method.getName().equals("main") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals("java.lang.String[]") || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().getName().equals("void") || !ctClass.hasAnnotation("cn.hserver.core.ioc.annotation.HServerBoot")) continue;
                    jar.close();
                    return ctClass.getName();
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        jar.close();
        myClassLoader.close();
        throw new IllegalStateException("\u627e\u4e0d\u5230\u542f\u52a8\u7c7b,\u8bf7\u4f7f\u7528@HServerBoot\u6807\u8bb0\u4f60\u7684\u542f\u52a8\u7c7b");
    }
}

