/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import cn.hserver.core.ioc.annotation.HServerBoot;
import cn.hserver.plugins.maven.JarWriter;
import cn.hserver.plugins.maven.tools.tool.DefaultLayoutFactory;
import cn.hserver.plugins.maven.tools.tool.Layout;
import cn.hserver.plugins.maven.tools.tool.LayoutFactory;
import cn.hserver.plugins.maven.tools.tool.Libraries;
import cn.hserver.plugins.maven.tools.tool.Library;
import cn.hserver.plugins.maven.tools.tool.RepackagingLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.maven.plugin.logging.Log;

public class Repackager {
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private final File source;
    private Layout layout;
    private Log logger;

    public Repackager(File source, Log logger) {
        this.logger = logger;
        if (source == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (!source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file, got " + source.getAbsolutePath());
        }
        this.source = source.getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries) throws IOException {
        if (destination == null || destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.layout == null) {
            this.layout = this.getLayoutFactory().getLayout(this.source);
        }
        if (this.alreadyRepackaged()) {
            return;
        }
        destination = destination.getAbsoluteFile();
        File workingSource = this.source;
        if (this.source.equals(destination)) {
            workingSource = this.getBackupFile();
            workingSource.delete();
            this.renameFile(this.source, workingSource);
        }
        destination.delete();
        try (JarFile jarFileSource = new JarFile(workingSource);){
            this.repackage(jarFileSource, destination, libraries);
        }
    }

    private LayoutFactory getLayoutFactory() {
        return new DefaultLayoutFactory();
    }

    public final File getBackupFile() {
        return new File(this.source.getParentFile(), this.source.getName() + ".original");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyRepackaged() throws IOException {
        try (JarFile jarFile = new JarFile(this.source);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue("HServer-Jar-Plugin") != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackage(JarFile sourceJar, File destination, Libraries libraries) throws IOException {
        JarWriter writer = new JarWriter(destination);
        try {
            ArrayList<Library> unpackLibraries = new ArrayList<Library>();
            ArrayList<Library> standardLibraries = new ArrayList<Library>();
            libraries.doWithLibraries(library -> {
                File file = library.getFile();
                if (this.isZip(file)) {
                    if (library.isUnpackRequired()) {
                        unpackLibraries.add(library);
                    } else {
                        standardLibraries.add(library);
                    }
                }
            });
            this.repackage(sourceJar, writer, unpackLibraries, standardLibraries);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void repackage(JarFile sourceJar, JarWriter writer, List<Library> unpackLibraries, List<Library> standardLibraries) throws IOException {
        writer.writeManifest(this.buildManifest(sourceJar));
        HashSet<String> seen = new HashSet<String>();
        this.writeNestedLibraries(unpackLibraries, seen, writer);
        if (this.layout instanceof RepackagingLayout) {
            writer.writeEntries(sourceJar, new RenamingEntryTransformer(((RepackagingLayout)this.layout).getRepackagedClassesLocation()));
        } else {
            writer.writeEntries(sourceJar);
        }
        this.writeNestedLibraries(standardLibraries, seen, writer);
    }

    private void writeNestedLibraries(List<Library> libraries, Set<String> alreadySeen, JarWriter writer) throws IOException {
        for (Library library : libraries) {
            String destination = this.layout.getLibraryDestination(library.getName(), library.getScope());
            if (destination == null) continue;
            if (!alreadySeen.add(destination + library.getName())) {
                throw new IllegalStateException("Duplicate library " + library.getName());
            }
            writer.writeNestedLibrary(destination, library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
        }
        manifest = new Manifest(manifest);
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("HServer-Jar-Build-Tool", "HServer-Jar-Plugin");
        manifest.getMainAttributes().putValue("Start-Class", this.getStartClass());
        manifest.getMainAttributes().putValue("Main-Class", "cn.hserver.core.loader.HServerJarMainClassStart");
        return manifest;
    }

    private String getStartClass() throws IOException {
        ClassPool pool = ClassPool.getDefault();
        File f = this.getBackupFile();
        URL url1 = f.toURI().toURL();
        URLClassLoader myClassLoader = new URLClassLoader(new URL[]{url1}, Thread.currentThread().getContextClassLoader());
        JarFile jar = new JarFile(f);
        Enumeration<JarEntry> enumFiles = jar.entries();
        ClassPool classPool = ClassPool.getDefault();
        while (enumFiles.hasMoreElements()) {
            JarEntry entry = enumFiles.nextElement();
            String classFullName = entry.getName();
            if (!classFullName.endsWith(".class")) continue;
            try {
                CtMethod[] methods;
                InputStream inputStream = jar.getInputStream(entry);
                CtClass ctClass = classPool.makeClass(inputStream);
                inputStream.close();
                for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
                    if (!method.getName().equals("main") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals("java.lang.String[]") || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().getName().equals("void") || !ctClass.hasAnnotation(HServerBoot.class)) continue;
                    this.logger.info((CharSequence)("\u542f\u52a8\u7c7b\uff1a" + ctClass.getName()));
                    return ctClass.getName();
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        jar.close();
        myClassLoader.close();
        throw new IllegalStateException("\u627e\u4e0d\u5230\u542f\u52a8\u7c7b,\u8bf7\u4f7f\u7528@HServerBoot\u6807\u8bb0\u4f60\u7684\u542f\u52a8\u7c7b");
    }

    private static Class<?> loadClass(String fullClzName) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullClzName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + file + "' to '" + dest + "'");
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            throw new IllegalStateException("Unable to delete '" + file + "'");
        }
    }

    private static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        private RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarEntry transform(JarEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (entry.getName().startsWith("META-INF/") && !entry.getName().equals("META-INF/aop.xml") || entry.getName().startsWith("BOOT-INF/")) {
                return entry;
            }
            JarEntry renamedEntry = new JarEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            this.setCreationTimeIfPossible(entry, renamedEntry);
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            this.setLastAccessTimeIfPossible(entry, renamedEntry);
            this.setLastModifiedTimeIfPossible(entry, renamedEntry);
            return renamedEntry;
        }

        private void setCreationTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getCreationTime() != null) {
                    target.setCreationTime(source.getCreationTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void setLastAccessTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastAccessTime() != null) {
                    target.setLastAccessTime(source.getLastAccessTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void setLastModifiedTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastModifiedTime() != null) {
                    target.setLastModifiedTime(source.getLastModifiedTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }
}

