/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import cn.hserver.plugins.maven.CopyLoader;
import cn.hserver.plugins.maven.Repackager;
import cn.hserver.plugins.maven.tools.tool.ArtifactsLibraries;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class HServerPackagerMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    private Log logger = this.getLog();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.repackage();
        try {
            CopyLoader.start(this.getTargetFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("write loader exception", e);
        }
    }

    private void repackage() throws MojoExecutionException, MojoFailureException {
        File sourceFile = this.project.getArtifact().getFile();
        Repackager repackager = new Repackager(sourceFile, this.logger);
        File target = this.getTargetFile();
        Set artifacts = this.project.getArtifacts();
        ArtifactsLibraries libraries = new ArtifactsLibraries(artifacts, Collections.emptyList(), this.getLog());
        try {
            repackager.repackage(target, libraries);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String name = this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }
}

