/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugins.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class CopyLoader {
    static String path;
    static String name;
    static String tempName;
    static String HServerName;

    public static void start(File file) throws Exception {
        name = file.getName();
        tempName = UUID.randomUUID().toString() + ".jar";
        HServerName = UUID.randomUUID().toString() + ".jar";
        path = file.getAbsolutePath().replace(name, "");
        CopyLoader.getHServerJar();
        CopyLoader.setLoader();
        CopyLoader.organizeFiles();
    }

    private static void organizeFiles() {
        new File(path + name).delete();
        new File(path + HServerName).delete();
        new File(path + tempName).renameTo(new File(path + name));
    }

    private static void setLoader() throws IOException {
        JarFile jarfile = new JarFile(path + HServerName);
        JarFile targetJarfile = new JarFile(path + name);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(path + tempName));
        Enumeration<JarEntry> entries = jarfile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().contains("cn/hserver/core/loader/") || !jarEntry.getName().endsWith(".class")) continue;
            jarOutputStream.putNextEntry(jarEntry);
            byte[] bytes = CopyLoader.toByteArray(jarfile.getInputStream(jarEntry));
            jarOutputStream.write(bytes);
        }
        Enumeration<JarEntry> targetEntries = targetJarfile.entries();
        while (targetEntries.hasMoreElements()) {
            JarEntry entry = targetEntries.nextElement();
            InputStream entryInputStream = targetJarfile.getInputStream(entry);
            jarOutputStream.putNextEntry(entry);
            jarOutputStream.write(CopyLoader.toByteArray(entryInputStream));
        }
        jarOutputStream.flush();
        jarOutputStream.close();
        targetJarfile.close();
        jarfile.close();
    }

    private static void getHServerJar() throws Exception {
        JarFile jarfile = new JarFile(path + name);
        Enumeration<JarEntry> entries = jarfile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().endsWith(".jar") || !jarEntry.getName().startsWith("lib/hserver")) continue;
            InputStream inputStream = jarfile.getInputStream(jarEntry);
            CopyLoader.writeToLocal(path + HServerName, inputStream);
            break;
        }
        jarfile.close();
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private static void writeToLocal(String destination, InputStream input) throws IOException {
        int index;
        byte[] bytes = new byte[1024];
        FileOutputStream downloadFile = new FileOutputStream(destination);
        while ((index = input.read(bytes)) != -1) {
            downloadFile.write(bytes, 0, index);
            downloadFile.flush();
        }
        downloadFile.close();
        input.close();
    }

    static {
        HServerName = "HServer.jar";
    }
}

