/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.protocol;

import cn.hserver.core.interfaces.ProtocolDispatcherSuperAdapter;
import cn.hserver.core.ioc.annotation.Bean;
import cn.hserver.core.ioc.annotation.Order;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.enums.GatewayMode;
import cn.hserver.plugin.gateway.handler.http7.Http7FrontendHandler;
import cn.hserver.plugin.gateway.handler.http7.Http7WebSocketFrontendHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.net.InetSocketAddress;

@Bean
@Order(value=1)
public class DispatchHttp7GateWay
implements ProtocolDispatcherSuperAdapter {
    public boolean dispatcher(Channel channel, ChannelPipeline pipeline) {
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        if (GateWayConfig.GATEWAY_MODE == GatewayMode.HTTP_7 && GateWayConfig.PORT.contains(socketAddress.getPort())) {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(Integer.MAX_VALUE)});
            pipeline.addLast(new ChannelHandler[]{new Http7WebSocketFrontendHandler()});
            pipeline.addLast(new ChannelHandler[]{new Http7FrontendHandler()});
            return true;
        }
        return false;
    }
}

