/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.protocol;

import cn.hserver.core.interfaces.ProtocolDispatcherAdapter;
import cn.hserver.core.ioc.annotation.Bean;
import cn.hserver.core.ioc.annotation.Order;
import cn.hserver.core.server.util.protocol.HostUtil;
import cn.hserver.core.server.util.protocol.ProtocolUtil;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.enums.GatewayMode;
import cn.hserver.plugin.gateway.handler.http4.Http4FrontendHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
@Order(value=1)
public class DispatchHttp4GateWay
implements ProtocolDispatcherAdapter {
    private static final Logger log = LoggerFactory.getLogger(DispatchHttp4GateWay.class);

    public boolean dispatcher(ChannelHandlerContext ctx, ChannelPipeline pipeline, byte[] headers) {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        if (GateWayConfig.GATEWAY_MODE == GatewayMode.HTTP_4 && GateWayConfig.PORT.contains(socketAddress.getPort())) {
            String host = HostUtil.getHost((ByteBuffer)ByteBuffer.wrap(headers));
            if (host != null) {
                pipeline.addLast(new ChannelHandler[]{new Http4FrontendHandler(host)});
                return true;
            }
            log.error("\u4e0d\u662f\u6807\u51c6http\u6570\u636e\u5305");
            ProtocolUtil.print((ChannelHandlerContext)ctx, (String)DispatchHttp4GateWay.class.getName(), (byte[])headers);
            return false;
        }
        return false;
    }
}

