/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.tcp;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.util.ReleaseUtil;
import cn.hserver.plugin.gateway.business.Business;
import cn.hserver.plugin.gateway.business.BusinessTcp;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.handler.tcp.BackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(FrontendHandler.class);
    private Channel outboundChannel;
    private static BusinessTcp businessTcp;

    public FrontendHandler() {
        for (Business business : IocUtil.getListBean(Business.class)) {
            if (!(business instanceof BusinessTcp)) continue;
            businessTcp = (BusinessTcp)business;
        }
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            businessTcp.close(ch);
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.debug("\u9650\u5236\u64cd\u4f5c\uff0c\u8ba9\u4e24\u4e2a\u901a\u9053\u5b9e\u73b0\u540c\u6b65\u8bfb\u5199 \u5f00\u5173\u72b6\u6001:{}", (Object)ctx.channel().isWritable());
        this.outboundChannel.config().setAutoRead(ctx.channel().isWritable());
        super.channelWritabilityChanged(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws InterruptedException {
        try {
            Channel inboundChannel = ctx.channel();
            Bootstrap b = new Bootstrap();
            b.group(GateWayConfig.EVENT_EXECUTORS);
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new BackendHandler(inboundChannel, businessTcp));
            SocketAddress proxyHost = businessTcp.getProxyHost(ctx, (Object)null, ctx.channel().remoteAddress());
            AtomicInteger count = new AtomicInteger(0);
            while (true) {
                try {
                    while (true) {
                        if (this.outboundChannel != null && this.outboundChannel.isActive()) {
                            return;
                        }
                        this.outboundChannel = b.connect(proxyHost).sync().channel();
                    }
                }
                catch (Exception e) {
                    if (businessTcp.connectController(ctx, false, count.incrementAndGet(), e)) continue;
                    FrontendHandler.closeOnFlush(ctx.channel());
                    return;
                }
                break;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ctx.close();
            return;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            Object in = businessTcp.in(ctx, msg);
            if (in == null) {
                ReleaseUtil.release((Object)in);
                return;
            }
            if (this.outboundChannel == null || !this.outboundChannel.isActive()) {
                ReleaseUtil.release((Object)msg);
                FrontendHandler.closeOnFlush(ctx.channel());
                return;
            }
            this.outboundChannel.writeAndFlush(in).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    ReleaseUtil.release((Object)in);
                    future.channel().close();
                }
            }));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ReleaseUtil.release((Object)msg);
            throw e;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        businessTcp.exceptionCaught(ctx, cause);
        FrontendHandler.closeOnFlush(ctx.channel());
    }
}

