/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http7;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.plugin.gateway.business.Business;
import cn.hserver.plugin.gateway.business.BusinessHttp7;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.handler.http7.Http7WebSocketBackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http7WebSocketFrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http7WebSocketFrontendHandler.class);
    private Channel outboundChannel;
    private static BusinessHttp7 businessHttp7;
    private WebSocketServerHandshaker handshake;

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.debug("\u9650\u5236\u64cd\u4f5c\uff0c\u8ba9\u4e24\u4e2a\u901a\u9053\u5b9e\u73b0\u540c\u6b65\u8bfb\u5199 \u5f00\u5173\u72b6\u6001:{}", (Object)ctx.channel().isWritable());
        this.outboundChannel.config().setAutoRead(ctx.channel().isWritable());
        super.channelWritabilityChanged(ctx);
    }

    public Http7WebSocketFrontendHandler() {
        for (Business business : IocUtil.getListBean(Business.class)) {
            if (!(business instanceof BusinessHttp7)) continue;
            businessHttp7 = (BusinessHttp7)business;
        }
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            businessHttp7.close(ch);
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void read(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest || msg instanceof WebSocketFrame) {
            this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    future.channel().close();
                    ReferenceCountUtil.release((Object)msg);
                }
            }));
        } else {
            Http7WebSocketFrontendHandler.closeOnFlush(ctx.channel());
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame msg) {
        if (this.outboundChannel != null) {
            try {
                Object in = businessHttp7.in(ctx, msg);
                if (in == null) {
                    return;
                }
                this.outboundChannel.writeAndFlush(in);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private void writeWebSocket(final ChannelHandlerContext ctx, final HttpRequest request) throws URISyntaxException {
        try {
            if (this.outboundChannel == null || !this.outboundChannel.isActive()) {
                final Bootstrap b = new Bootstrap();
                b.group(GateWayConfig.EVENT_EXECUTORS);
                final SocketAddress proxyHost = businessHttp7.getProxyHost(ctx, request, ctx.channel().localAddress());
                if (!request.headers().contains((CharSequence)HttpHeaderNames.ORIGIN)) {
                    request.headers().add((CharSequence)HttpHeaderNames.ORIGIN, (Object)(proxyHost.toString() + request.uri()));
                }
                WebSocketClientHandshaker webSocketClientHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI(request.uri()), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)request.headers());
                final Http7WebSocketBackendHandler handler = new Http7WebSocketBackendHandler(webSocketClientHandshaker, ctx.channel(), businessHttp7);
                ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), WebSocketClientCompressionHandler.INSTANCE, handler});
                    }
                });
                final AtomicInteger count = new AtomicInteger(0);
                ChannelFuture f = b.connect(proxyHost).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            try {
                                handler.handshakeFuture().addListener(future1 -> {
                                    future1.sync();
                                    future.channel().writeAndFlush((Object)request);
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ReferenceCountUtil.release((Object)request);
                            }
                        } else {
                            future.channel().close();
                            if (businessHttp7.connectController(ctx, false, count.incrementAndGet(), future.cause())) {
                                b.connect(proxyHost).addListener((GenericFutureListener)this);
                            } else {
                                ReferenceCountUtil.release((Object)request);
                                Http7WebSocketFrontendHandler.closeOnFlush(ctx.channel());
                            }
                        }
                    }
                });
                this.outboundChannel = f.channel();
            } else {
                this.read(ctx, request);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ReferenceCountUtil.release((Object)request);
            throw e;
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (this.isWebSocketRequest(req)) {
            Object in = businessHttp7.in(ctx, req);
            if (in == null) {
                return;
            }
            req = (HttpRequest)in;
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.uri(), null, true);
            this.handshake = wsFactory.newHandshaker(req);
            if (this.handshake == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshake.handshake(ctx.channel(), req);
                this.writeWebSocket(ctx, req);
            }
        } else {
            ctx.fireChannelRead((Object)req);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http7WebSocketFrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Http7WebSocketFrontendHandler.closeOnFlush(ctx.channel());
    }

    private boolean isWebSocketRequest(Object msg) {
        HttpRequest req = (HttpRequest)msg;
        return req != null && req.decoderResult().isSuccess() && "websocket".equals(req.headers().get("Upgrade"));
    }
}

