/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http7;

import cn.hserver.core.server.util.ReleaseUtil;
import cn.hserver.plugin.gateway.business.BusinessHttp7;
import cn.hserver.plugin.gateway.handler.http7.Http7FrontendHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Http7WebSocketBackendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http7WebSocketBackendHandler.class);
    private final WebSocketClientHandshaker handshakes;
    private ChannelPromise handshakeFuture;
    private final Channel inboundChannel;
    private final BusinessHttp7 businessHttp7;

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.debug("\u9650\u5236\u64cd\u4f5c\uff0c\u8ba9\u4e24\u4e2a\u901a\u9053\u5b9e\u73b0\u540c\u6b65\u8bfb\u5199 \u5f00\u5173\u72b6\u6001:{}", (Object)ctx.channel().isWritable());
        this.inboundChannel.config().setAutoRead(ctx.channel().isWritable());
        super.channelWritabilityChanged(ctx);
    }

    public Http7WebSocketBackendHandler(WebSocketClientHandshaker handshaker, Channel inboundChannel, BusinessHttp7 businessHttp7) {
        this.handshakes = handshaker;
        this.inboundChannel = inboundChannel;
        this.businessHttp7 = businessHttp7;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshakes.handshake(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (!this.handshakes.isHandshakeComplete()) {
            try {
                this.handshakes.finishHandshake(ch, (FullHttpResponse)msg);
                log.info("websocket Handshake \u5b8c\u6210!");
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                log.info("websocket\u8fde\u63a5\u5931\u8d25!");
                this.handshakeFuture.setFailure((Throwable)e);
            }
            ReleaseUtil.release((Object)msg);
            return;
        }
        if (msg instanceof WebSocketFrame) {
            try {
                Object out = this.businessHttp7.out(this.inboundChannel, msg);
                if (out == null) {
                    return;
                }
                this.inboundChannel.writeAndFlush(out);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        } else {
            ctx.channel().close();
            ReleaseUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Http7FrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        this.businessHttp7.exceptionCaught(ctx, cause);
        Http7FrontendHandler.closeOnFlush(ctx.channel());
    }
}

