/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http7;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.util.ReleaseUtil;
import cn.hserver.plugin.gateway.business.Business;
import cn.hserver.plugin.gateway.business.BusinessHttp7;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.handler.http7.Http7BackendHandler;
import cn.hserver.plugin.gateway.ssl.HttpsMapperSslContextFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http7FrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http7FrontendHandler.class);
    private Channel outboundChannel;
    private static BusinessHttp7 businessHttp7;

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.debug("\u9650\u5236\u64cd\u4f5c\uff0c\u8ba9\u4e24\u4e2a\u901a\u9053\u5b9e\u73b0\u540c\u6b65\u8bfb\u5199 \u5f00\u5173\u72b6\u6001:{}", (Object)ctx.channel().isWritable());
        this.outboundChannel.config().setAutoRead(ctx.channel().isWritable());
        super.channelWritabilityChanged(ctx);
    }

    public Http7FrontendHandler() {
        for (Business business : IocUtil.getListBean(Business.class)) {
            if (!(business instanceof BusinessHttp7)) continue;
            businessHttp7 = (BusinessHttp7)business;
        }
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            businessHttp7.close(ch);
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void read(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.outboundChannel.writeAndFlush(msg);
        } else {
            Http7FrontendHandler.closeOnFlush(ctx.channel());
            ReleaseUtil.release((Object)msg);
        }
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
        try {
            final Object in = businessHttp7.in(ctx, msg);
            if (in == null) {
                ReleaseUtil.release((Object)msg);
                return;
            }
            if (this.outboundChannel == null || !this.outboundChannel.isActive()) {
                final Channel inboundChannel = ctx.channel();
                final Bootstrap b = new Bootstrap();
                b.group(GateWayConfig.EVENT_EXECUTORS);
                final InetSocketAddress proxyHost = (InetSocketAddress)businessHttp7.getProxyHost(ctx, in, ctx.channel().localAddress());
                ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        if (proxyHost.getPort() == 443) {
                            SSLEngine sslEngine = HttpsMapperSslContextFactory.getClientContext().createSSLEngine();
                            sslEngine.setUseClientMode(true);
                            ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE)});
                        ch.pipeline().addLast(new ChannelHandler[]{new Http7BackendHandler(inboundChannel, businessHttp7)});
                    }
                });
                final AtomicInteger count = new AtomicInteger(0);
                ChannelFuture f = b.connect((SocketAddress)proxyHost).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            future.channel().writeAndFlush(in);
                        } else {
                            future.channel().close();
                            if (businessHttp7.connectController(ctx, false, count.incrementAndGet(), future.cause())) {
                                b.connect((SocketAddress)proxyHost).addListener((GenericFutureListener)this);
                            } else {
                                ReleaseUtil.release((Object)in);
                                Http7FrontendHandler.closeOnFlush(ctx.channel());
                            }
                        }
                    }
                });
                this.outboundChannel = f.channel();
            } else {
                this.read(ctx, in);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ReleaseUtil.release((Object)msg);
            throw e;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http7FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        businessHttp7.exceptionCaught(ctx, cause);
        Http7FrontendHandler.closeOnFlush(ctx.channel());
    }
}

