/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http4;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.util.ReleaseUtil;
import cn.hserver.plugin.gateway.bean.Http4Data;
import cn.hserver.plugin.gateway.business.Business;
import cn.hserver.plugin.gateway.business.BusinessHttp4;
import cn.hserver.plugin.gateway.config.GateWayConfig;
import cn.hserver.plugin.gateway.handler.http4.Http4BackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http4FrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http4FrontendHandler.class);
    private Channel outboundChannel;
    private final String host;
    private static BusinessHttp4 businessHttp4;

    public Http4FrontendHandler(String host) {
        this.host = host;
        for (Business business : IocUtil.getListBean(Business.class)) {
            if (!(business instanceof BusinessHttp4)) continue;
            businessHttp4 = (BusinessHttp4)business;
        }
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.outboundChannel != null) {
            this.outboundChannel.config().setAutoRead(ctx.channel().isWritable());
        }
        super.channelWritabilityChanged(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(GateWayConfig.EVENT_EXECUTORS)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new Http4BackendHandler(inboundChannel, businessHttp4)});
            }
        });
        SocketAddress proxyHost = businessHttp4.getProxyHost(ctx, new Http4Data(this.host, null), ctx.channel().remoteAddress());
        AtomicInteger count = new AtomicInteger(0);
        while (true) {
            try {
                while (true) {
                    if (this.outboundChannel != null && this.outboundChannel.isActive()) {
                        return;
                    }
                    this.outboundChannel = b.connect(proxyHost).sync().channel();
                }
            }
            catch (Exception e) {
                if (businessHttp4.connectController(ctx, false, count.incrementAndGet(), e)) continue;
                Http4FrontendHandler.closeOnFlush(ctx.channel());
                return;
            }
            break;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            Object in = businessHttp4.in(ctx, new Http4Data(this.host, msg));
            if (in == null) {
                ReleaseUtil.release((Object)msg);
                return;
            }
            if (this.outboundChannel == null || !this.outboundChannel.isActive()) {
                ReleaseUtil.release((Object)msg);
                Http4FrontendHandler.closeOnFlush(ctx.channel());
                return;
            }
            this.outboundChannel.writeAndFlush(in).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    ReleaseUtil.release((Object)in);
                    future.channel().close();
                }
            }));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ReleaseUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http4FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!(cause instanceof IOException)) {
            log.error("WEB\u901a\u9053 ......", cause);
        }
        Http4FrontendHandler.closeOnFlush(ctx.channel());
    }
}

