/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http4;

import cn.hserver.core.server.util.ReleaseUtil;
import cn.hserver.plugin.gateway.business.BusinessHttp4;
import cn.hserver.plugin.gateway.handler.http4.Http4FrontendHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http4BackendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http4BackendHandler.class);
    private final Channel inboundChannel;
    private final BusinessHttp4 businessHttp4;

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.debug("\u9650\u5236\u64cd\u4f5c\uff0c\u8ba9\u4e24\u4e2a\u901a\u9053\u5b9e\u73b0\u540c\u6b65\u8bfb\u5199 \u5f00\u5173\u72b6\u6001:{}", (Object)ctx.channel().isWritable());
        this.inboundChannel.config().setAutoRead(ctx.channel().isWritable());
        super.channelWritabilityChanged(ctx);
    }

    public Http4BackendHandler(Channel inboundChannel, BusinessHttp4 businessHttp4) {
        this.inboundChannel = inboundChannel;
        this.businessHttp4 = businessHttp4;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            Object out = this.businessHttp4.out(this.inboundChannel, msg);
            if (out == null) {
                ReleaseUtil.release((Object)msg);
                return;
            }
            this.inboundChannel.writeAndFlush(out).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    ReleaseUtil.release((Object)out);
                    future.channel().close();
                }
            }));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            ctx.channel().close();
            ReleaseUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Http4FrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Http4FrontendHandler.closeOnFlush(ctx.channel());
    }
}

