/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http4;

import cn.hserver.plugin.gateway.handler.http4.Http4BackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http4FrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(Http4FrontendHandler.class);
    private Channel outboundChannel;

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg) {
        this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                future.channel().close();
                ReferenceCountUtil.release((Object)msg);
            }
        }));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.outboundChannel != null) {
            if (this.outboundChannel.isActive()) {
                this.write(ctx, msg);
            } else {
                this.outboundChannel.close();
                this.outboundChannel = null;
                ReferenceCountUtil.release((Object)msg);
            }
        } else {
            Channel inboundChannel = ctx.channel();
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)inboundChannel.eventLoop());
            ((Bootstrap)((Bootstrap)b.option(ChannelOption.AUTO_READ, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new Http4BackendHandler(inboundChannel));
            b.connect("127.0.0.1", -1).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    this.outboundChannel = future.channel();
                    inboundChannel.read();
                    this.write(ctx, msg);
                } else {
                    inboundChannel.close();
                    ReferenceCountUtil.release((Object)msg);
                }
            }));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http4FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        Http4FrontendHandler.closeOnFlush(ctx.channel());
    }
}

