/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http4;

import cn.hserver.plugin.gateway.handler.http4.Http4FrontendHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class Http4BackendHandler
extends ChannelInboundHandlerAdapter {
    private final Channel inboundChannel;

    public Http4BackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.inboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                future.channel().close();
                ReferenceCountUtil.release((Object)msg);
            }
        }));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Http4FrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        Http4FrontendHandler.closeOnFlush(ctx.channel());
    }
}

