/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.tcp;

import cn.hserver.plugin.gateway.handler.tcp.BackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;

public class FrontendHandler
extends ChannelInboundHandlerAdapter {
    private Channel outboundChannel;

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)inboundChannel.eventLoop());
        ((Bootstrap)((Bootstrap)b.option(ChannelOption.AUTO_READ, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new BackendHandler(inboundChannel));
        String remoteHost = "";
        int remotePort = 8888;
        ChannelFuture f = b.connect(remoteHost, remotePort).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                inboundChannel.read();
            } else {
                inboundChannel.close();
            }
        }));
        this.outboundChannel = f.channel();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.outboundChannel.isActive()) {
            this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        FrontendHandler.closeOnFlush(ctx.channel());
    }
}

