/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.gateway.handler.http7;

import cn.hserver.plugin.gateway.handler.http7.Http7BackendHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class Http7FrontendHandler
extends ChannelInboundHandlerAdapter {
    private Channel outboundChannel;

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void read(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.outboundChannel.writeAndFlush(msg);
        } else {
            Http7FrontendHandler.closeOnFlush(ctx.channel());
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.outboundChannel == null) {
            HttpRequest httpRequest = (HttpRequest)msg;
            String host = httpRequest.headers().get("Host");
            final Channel inboundChannel = ctx.channel();
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)ctx.channel().eventLoop());
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new ChunkedWriteHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http7BackendHandler(inboundChannel)});
                }
            });
            ChannelFuture f = b.connect("127.0.0.1", -1).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush(msg);
                } else {
                    future.channel().close();
                    ReferenceCountUtil.release((Object)msg);
                }
            }));
            this.outboundChannel = f.channel();
        } else {
            this.read(ctx, msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http7FrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        Http7FrontendHandler.closeOnFlush(ctx.channel());
    }
}

