/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.cloud;

import cn.hserver.plugin.cloud.ServerInstance;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DynamicRoundRobin {
    private final List<ServerInstance> list = new CopyOnWriteArrayList<ServerInstance>();
    private final AtomicInteger pos = new AtomicInteger(0);

    public DynamicRoundRobin() {
    }

    public DynamicRoundRobin(ServerInstance t) {
        this.list.add(t);
    }

    public void add(ServerInstance t) {
        if (t.isHealthy()) {
            for (ServerInstance serverInstance : this.list) {
                if (!serverInstance.getEq().equals(t.getEq())) continue;
                return;
            }
            this.list.add(t);
        } else {
            this.remove(t);
        }
    }

    public List<ServerInstance> getAll() {
        return this.list;
    }

    public boolean remove(ServerInstance t) {
        return this.list.remove(t);
    }

    public void removeAll() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.remove(i);
        }
    }

    public int size() {
        return this.list.size();
    }

    public ServerInstance choose() {
        int size;
        while ((size = this.list.size()) != 0) {
            int p = this.pos.getAndIncrement();
            if (p > size - 1) {
                this.pos.set(0);
                continue;
            }
            try {
                return this.list.get(p);
            }
            catch (IndexOutOfBoundsException e) {
                this.pos.set(0);
                continue;
            }
            break;
        }
        return null;
    }
}

