/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.build;

import cn.hserver.build.JarUtil;
import cn.hserver.runner.TestStartRunner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class ReBuilderJar {
    private final JarOutputStream jarOutputStream;

    public ReBuilderJar(String pathJar) throws IOException {
        this.jarOutputStream = new JarOutputStream(Files.newOutputStream(Paths.get(pathJar, new String[0]), new OpenOption[0]));
    }

    public void buildNewJar(MavenProject project) throws IOException {
        Set dependencies = project.getArtifacts();
        for (Artifact dependency : dependencies) {
            File sourceFile = dependency.getFile();
            JarUtil.addFileToJar("lib/" + sourceFile.getName().trim(), sourceFile, this.jarOutputStream);
        }
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        JarUtil.addFileToJar("lib/" + project.getBuild().getFinalName() + "." + project.getPackaging(), new File(artifactPath), this.jarOutputStream);
    }

    public void addManifest(MavenProject project) throws IOException {
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        String mainClassName = JarUtil.getMainClassName(artifactPath);
        this.jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Created-By", "HServer");
        manifest.getMainAttributes().putValue("Start-Class", mainClassName);
        manifest.getMainAttributes().putValue("Main-Class", "cn.hserver.runner.TestStartRunner");
        manifest.write(new BufferedOutputStream(this.jarOutputStream));
    }

    public void copySource(MavenProject project) throws IOException {
        String artifactPath = project.getBuild().getDirectory() + "/" + project.getBuild().getFinalName() + "." + project.getPackaging();
        JarUtil.copyJarEntries(artifactPath, this.jarOutputStream);
    }

    public void addRunner() throws IOException, URISyntaxException {
        String path;
        ProtectionDomain protectionDomain = TestStartRunner.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path != null && (path.endsWith(".jar") || path.endsWith(".jar!/"))) {
            String s = path.replaceAll("file:", "").replaceAll("!/", "");
            JarUtil.copyJarEntries(s, this.jarOutputStream);
        }
    }

    public void close() throws IOException {
        this.jarOutputStream.close();
    }
}

