/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.build;

import cn.hserver.core.ioc.annotation.HServerBoot;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class JarUtil {
    public static void addFileToJar(String entryName, File file, JarOutputStream jarOutputStream) throws IOException {
        int bytesRead;
        JarEntry jarEntry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(jarEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        while ((bytesRead = fileInputStream.read(buffer)) != -1) {
            jarOutputStream.write(buffer, 0, bytesRead);
        }
        fileInputStream.close();
        jarOutputStream.closeEntry();
    }

    public static void copyJarEntries(String sourceJarPath, JarOutputStream targetJar) throws IOException {
        try (JarFile sourceJar = new JarFile(sourceJarPath);){
            Enumeration<JarEntry> entries = sourceJar.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().contains("META-INF")) continue;
                JarEntry newEntry = new JarEntry(jarEntry.getName());
                targetJar.putNextEntry(newEntry);
                InputStream entryInputStream = sourceJar.getInputStream(jarEntry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                    targetJar.write(buffer, 0, bytesRead);
                }
                targetJar.closeEntry();
                entryInputStream.close();
            }
        }
    }

    public static String getMainClassName(String jarPath) throws IOException {
        File f = new File(jarPath);
        URL url1 = f.toURI().toURL();
        URLClassLoader myClassLoader = new URLClassLoader(new URL[]{url1}, Thread.currentThread().getContextClassLoader());
        JarFile jar = new JarFile(jarPath);
        Enumeration<JarEntry> enumFiles = jar.entries();
        ClassPool classPool = ClassPool.getDefault();
        while (enumFiles.hasMoreElements()) {
            JarEntry entry = enumFiles.nextElement();
            String classFullName = entry.getName();
            if (!classFullName.endsWith(".class")) continue;
            try {
                CtMethod[] methods;
                InputStream inputStream = jar.getInputStream(entry);
                CtClass ctClass = classPool.makeClass(inputStream);
                inputStream.close();
                for (CtMethod method : methods = ctClass.getDeclaredMethods()) {
                    if (!method.getName().equals("main") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals("java.lang.String[]") || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().getName().equals("void") || !ctClass.hasAnnotation(HServerBoot.class)) continue;
                    return ctClass.getName();
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        jar.close();
        myClassLoader.close();
        throw new IllegalStateException("\u627e\u4e0d\u5230\u542f\u52a8\u7c7b,\u8bf7\u4f7f\u7528@HServerBoot\u6807\u8bb0\u4f60\u7684\u542f\u52a8\u7c7b");
    }
}

