/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.beetlsql.hook;

import cn.hserver.core.interfaces.HookAdapter;
import cn.hserver.core.ioc.annotation.Hook;
import cn.hserver.plugin.beetlsql.tx.Tx;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.beetl.sql.core.DSTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Hook(value={Tx.class})
public class TxHook
implements HookAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TxHook.class);
    private static final FastThreadLocal<Long> TIMEOUT_MILLISECOND = new FastThreadLocal();

    public void before(Class aClass, Method method, Object[] objects) {
        Tx annotation = method.getAnnotation(Tx.class);
        if (annotation != null) {
            DSTransactionManager.start();
            if (annotation.timeoutMillisecond() != -1) {
                TIMEOUT_MILLISECOND.set((Object)System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object after(Class aClass, Method method, Object o) {
        try {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation != null) {
                try {
                    if (annotation.timeoutMillisecond() != -1) {
                        Long startTime = (Long)TIMEOUT_MILLISECOND.get();
                        if (System.currentTimeMillis() - startTime > (long)annotation.timeoutMillisecond()) {
                            try {
                                DSTransactionManager.rollback();
                            }
                            catch (SQLException ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                    DSTransactionManager.commit();
                }
                catch (SQLException e) {
                    try {
                        DSTransactionManager.rollback();
                    }
                    catch (SQLException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            Object object = o;
            return object;
        }
        finally {
            TIMEOUT_MILLISECOND.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void throwable(Class aClass, Method method, Throwable throwable) {
        block11: {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation == null) return;
            try {
                int n;
                Class<? extends Throwable>[] classArray;
                Class<? extends Throwable>[] classes = annotation.rollbackFor();
                if (classes.length != 0) {
                    classArray = classes;
                    n = classArray.length;
                } else {
                    DSTransactionManager.rollback();
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    Class<? extends Throwable> aClass1 = classArray[i];
                    if (throwable.getClass() != aClass1) continue;
                    DSTransactionManager.rollback();
                    break block11;
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            DSTransactionManager.commit();
            TIMEOUT_MILLISECOND.remove();
            return;
        }
        TIMEOUT_MILLISECOND.remove();
    }
}

