/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.util;

import cn.hserver.core.config.ConstConfig;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;

public class PackageUtil {
    public static Set<String> deduplication(Set<String> stringSet) {
        HashSet<String> newPackage = new HashSet<String>();
        Iterator iterator = stringSet.stream().iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            String s = stringSet.stream().filter(e -> next.startsWith((String)e) && !e.equals(next)).findFirst().orElse(null);
            if (s != null) {
                newPackage.add(s);
                continue;
            }
            newPackage.add(next);
        }
        return newPackage;
    }

    public static Set<String> scanPackage() {
        if (ConstConfig.RUN_JAR.booleanValue()) {
            return PackageUtil.onlineFile(ConstConfig.CLASSPATH);
        }
        if (ConstConfig.CLASSPATH.endsWith("test-classes")) {
            Set<String> strings = PackageUtil.developFile(ConstConfig.CLASSPATH);
            Set<String> strings1 = PackageUtil.developFile(ConstConfig.CLASSPATH.replaceAll("test-classes", "classes"));
            strings.addAll(strings1);
            ConstConfig.CLASSPATH = ConstConfig.CLASSPATH.replaceAll("test-classes", "classes");
            return strings;
        }
        return PackageUtil.developFile(ConstConfig.CLASSPATH);
    }

    private static Set<String> developFile(String path) {
        File[] files;
        HashSet<String> tmp = new HashSet<String>();
        File file = new File(path);
        if (file.exists() && null != (files = file.listFiles())) {
            for (File file2 : files) {
                if (!file2.isDirectory()) continue;
                tmp.add(file2.getPath().substring(path.length() + 1));
            }
        }
        return tmp;
    }

    private static Set<String> onlineFile(String path) {
        HashSet<String> tmp = new HashSet<String>();
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)new URL(path).openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            jarFile.stream().forEach(jarEntry -> {
                try {
                    String name = jarEntry.getName();
                    tmp.add(name.substring(0, name.indexOf("/")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }
}

