/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.Loader;

public class ClassLoadUtil {
    private static ClassLoader classLoader;

    public static List<Class<?>> loadClasses(String packageName, boolean isJavassist) {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        try {
            if (isJavassist) {
                ClassPool cp = ClassPool.getDefault();
                Loader loader = new Loader(Thread.currentThread().getContextClassLoader(), cp);
                loader.delegateLoadingOf("jdk.internal.reflect.");
                classLoader = loader;
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Enumeration<URL> dirs = classLoader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassLoadUtil.findAndLoadClassesInPackageByFile(packageName, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    return entries;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classes;
    }

    private static void findAndLoadClassesInPackageByFile(String packageName, String packagePath, List<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
        assert (dirfiles != null);
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                ClassLoadUtil.findAndLoadClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                classes.add(classLoader.loadClass(packageName + '.' + className));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

