/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.util;

import java.util.Stack;

public class Calculator {
    public static double calculate(String expression) {
        char[] tokens = expression.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == ' ') continue;
            if (Character.isDigit(tokens[i]) || tokens[i] == '.' || tokens[i] == '-' && (i == 0 || tokens[i - 1] == '(')) {
                StringBuilder sb = new StringBuilder();
                while (i < tokens.length && (Character.isDigit(tokens[i]) || tokens[i] == '.' || tokens[i] == '-' && (i == 0 || tokens[i - 1] == '('))) {
                    sb.append(tokens[i++]);
                }
                values.push(Double.parseDouble(sb.toString()));
                --i;
                continue;
            }
            if (tokens[i] == '(') {
                operators.push(Character.valueOf(tokens[i]));
                continue;
            }
            if (tokens[i] == ')') {
                while (((Character)operators.peek()).charValue() != '(') {
                    values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                operators.pop();
                continue;
            }
            if (tokens[i] != '+' && tokens[i] != '-' && tokens[i] != '*' && tokens[i] != '/' && tokens[i] != '^' && tokens[i] != '%') continue;
            while (!operators.empty() && Calculator.hasPrecedence(tokens[i], ((Character)operators.peek()).charValue())) {
                values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
            }
            operators.push(Character.valueOf(tokens[i]));
        }
        while (!operators.empty()) {
            values.push(Calculator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        return op1 != '*' && op1 != '/' && op1 != '^' && op1 != '%' || op2 != '+' && op2 != '-';
    }

    private static double applyOperator(char operator, double b, double a) {
        switch (operator) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new ArithmeticException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
                }
                return a / b;
            }
            case '^': {
                return Math.pow(a, b);
            }
            case '%': {
                return a % b;
            }
        }
        return 0.0;
    }
}

