/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.scheduling;

import cn.hserver.core.config.ConstConfig;
import cn.hserver.core.scheduling.CronExpression;
import cn.hserver.core.scheduling.ScheduledThreadPoolExecutorPro;
import cn.hserver.core.scheduling.TaskJob;
import cn.hserver.core.scheduling.bean.TaskDefinition;
import cn.hserver.core.util.Calculator;
import cn.hserver.core.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private static final List<TaskDefinition> TASK_DEFINITIONS = new ArrayList<TaskDefinition>();
    private static final Map<String, ScheduledFuture<?>> CRON_TASK = new ConcurrentHashMap();
    private static final ScheduledThreadPoolExecutorPro SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutorPro((int)ConstConfig.taskPool, new NamedThreadFactory("hserver_task"));

    public static void addTask(TaskDefinition taskDefinition) {
        TASK_DEFINITIONS.add(taskDefinition);
    }

    public static void addTask(String name, String time, Class<? extends TaskJob> taskJob, Object ... args) {
        try {
            if (CRON_TASK.containsKey(name)) {
                log.warn("{} \u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)name);
                return;
            }
            TaskJob taskJob1 = taskJob.newInstance();
            try {
                CronExpression expression = new CronExpression(time);
                ScheduledFuture<?> submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit(expression, taskJob1, args);
                CRON_TASK.put(name, submit);
            }
            catch (Exception e) {
                try {
                    int times = Integer.parseInt(time);
                    ScheduledFuture<?> submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit((Integer)times, taskJob1, args);
                    CRON_TASK.put(name, submit);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Set<String> getAllTaskName() {
        return CRON_TASK.keySet();
    }

    public static boolean removeTask(String name) {
        boolean cancel;
        ScheduledFuture<?> scheduledFuture = CRON_TASK.get(name);
        if (scheduledFuture != null && (cancel = scheduledFuture.cancel(true))) {
            CRON_TASK.remove(name);
            return true;
        }
        return false;
    }

    public static boolean existTask(String name) {
        return CRON_TASK.containsKey(name);
    }

    public static synchronized void startTask() {
        if (TASK_DEFINITIONS.isEmpty()) {
            return;
        }
        for (TaskDefinition taskDefinition : TASK_DEFINITIONS) {
            if (CRON_TASK.containsKey(taskDefinition.getName())) {
                log.warn("{}\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)taskDefinition.getName());
                return;
            }
            try {
                CronExpression expression = new CronExpression(taskDefinition.getTime());
                ScheduledFuture<?> submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit(expression, taskDefinition.getBeanName(), taskDefinition.getMethod());
                CRON_TASK.put(taskDefinition.getName(), submit);
            }
            catch (Exception e) {
                try {
                    int times = (int)Calculator.calculate(taskDefinition.getTime());
                    ScheduledFuture<?> submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit((Integer)times, taskDefinition.getBeanName(), taskDefinition.getMethod());
                    CRON_TASK.put(taskDefinition.getName(), submit);
                }
                catch (Exception e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        TASK_DEFINITIONS.clear();
    }
}

