/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.scheduling;

import cn.hserver.core.context.IocApplicationContext;
import cn.hserver.core.scheduling.CronExecutorService;
import cn.hserver.core.scheduling.CronExpression;
import cn.hserver.core.scheduling.TaskJob;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledThreadPoolExecutorPro
extends ScheduledThreadPoolExecutor
implements CronExecutorService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledThreadPoolExecutorPro.class);

    ScheduledThreadPoolExecutorPro(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> submit(CronExpression expression, String beanName, Method method) {
        Runnable scheduleTask = () -> {
            Date now = new Date();
            Date time = expression.getNextValidTimeAfter(now);
            try {
                while (time != null) {
                    while (now.before(time)) {
                        Thread.sleep(time.getTime() - now.getTime());
                        now = new Date();
                    }
                    time = expression.getNextValidTimeAfter(now);
                    try {
                        method.setAccessible(true);
                        Object bean = IocApplicationContext.getBean(beanName);
                        if (bean == null) continue;
                        method.invoke(bean, this.getNullParm(method));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                return;
            }
            catch (CancellationException | RejectedExecutionException e) {
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return this.schedule(scheduleTask, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(Integer expression, String beanName, Method method) {
        Runnable scheduleTask = () -> {
            try {
                method.setAccessible(true);
                Object bean = IocApplicationContext.getBean(beanName);
                if (bean != null) {
                    method.invoke(bean, this.getNullParm(method));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        };
        return this.scheduleAtFixedRate(scheduleTask, expression.intValue(), expression.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(CronExpression expression, TaskJob taskJob, Object ... args) {
        Runnable scheduleTask = () -> {
            Date now = new Date();
            Date time = expression.getNextValidTimeAfter(now);
            try {
                while (time != null) {
                    while (now.before(time)) {
                        Thread.sleep(time.getTime() - now.getTime());
                        now = new Date();
                    }
                    time = expression.getNextValidTimeAfter(now);
                    try {
                        taskJob.exec(args);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (CancellationException | RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return this.schedule(scheduleTask, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(Integer expression, TaskJob taskJob, Object ... args) {
        Runnable scheduleTask = () -> {
            try {
                taskJob.exec(args);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        };
        return this.scheduleAtFixedRate(scheduleTask, expression.intValue(), expression.intValue(), TimeUnit.MILLISECONDS);
    }
}

