/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.queue.fqueue;

import cn.hserver.core.queue.QueueManager;
import cn.hserver.core.queue.bean.QueueData;
import cn.hserver.core.queue.bean.QueueHandleInfo;
import cn.hserver.core.queue.fqueue.FSQueue;
import cn.hserver.core.queue.fqueue.exception.FileFormatException;
import cn.hserver.core.util.NamedThreadFactory;
import cn.hserver.core.util.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FQueue
extends AbstractQueue<byte[]>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FQueue.class);
    private static final long serialVersionUID = -1L;
    private FSQueue fsQueue = null;
    private String queueName = null;
    private final Lock lock = new ReentrantReadWriteLock().writeLock();
    private ExecutorService executorService;

    public FQueue(String path, String queueName) throws IOException, FileFormatException {
        this.queueName = queueName;
        this.fsQueue = new FSQueue(path);
    }

    public FQueue(String path, int entityLimitLength) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(path, entityLimitLength);
    }

    public FQueue(File dir) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(dir);
    }

    public FQueue(File dir, int entityLimitLength) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(dir, entityLimitLength);
    }

    @Override
    public Iterator<byte[]> iterator() {
        throw new UnsupportedOperationException("iterator Unsupported now");
    }

    @Override
    public int size() {
        return this.fsQueue.getQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(byte[] e) {
        try {
            this.lock.lock();
            this.fsQueue.add(e);
            FQueue fQueue = this;
            synchronized (fQueue) {
                this.notifyAll();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileFormatException fileFormatException) {
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public byte[] peek() {
        try {
            this.lock.lock();
            byte[] byArray = this.fsQueue.readNext();
            return byArray;
        }
        catch (FileFormatException | IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] poll() {
        try {
            this.lock.lock();
            byte[] byArray = this.fsQueue.readNextAndRemove();
            return byArray;
        }
        catch (FileFormatException | IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.fsQueue.clear();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileFormatException fileFormatException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException, FileFormatException {
        if (this.fsQueue != null) {
            this.fsQueue.close();
            this.fsQueue = null;
        }
        this.stopHandler();
    }

    public void stopHandler() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            List<Runnable> runnables = this.executorService.shutdownNow();
            runnables.forEach(Runnable::run);
            this.executorService = null;
        }
    }

    public void restartHandler() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.start();
        }
    }

    public void start() {
        QueueHandleInfo queueHandleInfo = QueueManager.getQueueHandleInfo(this.queueName);
        if (queueHandleInfo == null) {
            return;
        }
        int threadSize = queueHandleInfo.getThreadSize();
        this.executorService = Executors.newFixedThreadPool(threadSize, new NamedThreadFactory(this.queueName + "-queue-handler"));
        for (int i = 0; i < threadSize; ++i) {
            this.executorService.submit(() -> {
                while (this.fsQueue != null && this.executorService != null && !this.executorService.isShutdown()) {
                    try {
                        Serializable deserialize;
                        if (threadSize == 1) {
                            byte[] peek = this.peek();
                            if (peek != null) {
                                deserialize = SerializationUtil.deserialize(peek, QueueData.class);
                                queueHandleInfo.getQueueEventHandler().invoke((QueueData)deserialize);
                                this.poll();
                                continue;
                            }
                            deserialize = this;
                            synchronized (deserialize) {
                                this.wait();
                                continue;
                            }
                        }
                        byte[] poll = this.poll();
                        if (poll != null) {
                            deserialize = SerializationUtil.deserialize(poll, QueueData.class);
                            queueHandleInfo.getQueueEventHandler().invoke((QueueData)deserialize);
                            continue;
                        }
                        FQueue fQueue = this;
                        synchronized (fQueue) {
                            this.wait();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            return;
                        }
                        log.error(e.getMessage(), (Throwable)e);
                        return;
                    }
                }
            });
        }
    }
}

