/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.queue;

import cn.hserver.core.config.ConstConfig;
import cn.hserver.core.queue.bean.QueueData;
import cn.hserver.core.queue.bean.QueueHandleInfo;
import cn.hserver.core.queue.bean.QueueInfo;
import cn.hserver.core.queue.fqueue.FQueue;
import cn.hserver.core.queue.fqueue.exception.FileFormatException;
import cn.hserver.core.util.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueManager {
    private static final Logger log = LoggerFactory.getLogger(QueueManager.class);
    private static final Map<String, QueueHandleInfo> handleMethodMap = new ConcurrentHashMap<String, QueueHandleInfo>();
    private static final Map<String, FQueue> FQ = new ConcurrentHashMap<String, FQueue>();

    private QueueManager() {
    }

    public static QueueHandleInfo getQueueHandleInfo(String queueName) {
        return handleMethodMap.get(queueName);
    }

    public static void removeQueue(String queueName, boolean trueDelete) {
        handleMethodMap.remove(queueName);
        FQueue fQueue = FQ.get(queueName);
        if (fQueue != null) {
            if (trueDelete) {
                fQueue.clear();
            }
            try {
                fQueue.close();
            }
            catch (FileFormatException | IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        FQ.remove(queueName);
    }

    public static void stopHandler(String queueName) {
        FQueue fQueue = FQ.get(queueName);
        if (fQueue != null) {
            fQueue.stopHandler();
        }
    }

    public static void restartHandler(String queueName) {
        FQueue fQueue = FQ.get(queueName);
        if (fQueue != null) {
            fQueue.restartHandler();
        }
    }

    public static List<String> getAllQueueName() {
        return new ArrayList<String>(FQ.keySet());
    }

    public static void addQueueListener(QueueHandleInfo eventHandleInfo) {
        handleMethodMap.put(eventHandleInfo.getQueueName(), eventHandleInfo);
    }

    public static boolean dispatcherSerializationQueue(String queueName, Object ... args) {
        FQueue fQueue = FQ.get(queueName);
        if (fQueue == null) {
            log.error("\u4e0d\u5b58\u5728:{} \u961f\u5217", (Object)queueName);
            return false;
        }
        fQueue.offer(SerializationUtil.serialize(new QueueData(queueName, args)));
        return true;
    }

    public static QueueInfo queueInfo(String queueName) {
        QueueHandleInfo queueHandleInfo = handleMethodMap.get(queueName);
        FQueue fQueue = FQ.get(queueName);
        return new QueueInfo(fQueue.size(), queueHandleInfo.getThreadSize(), queueName);
    }

    public static synchronized void startQueueServer() {
        handleMethodMap.forEach((queueName, v) -> {
            if (!FQ.containsKey(queueName)) {
                try {
                    FQueue fQueue = new FQueue(ConstConfig.PERSIST_PATH + File.separator + v.getQueueName(), v.getQueueName());
                    FQ.put((String)queueName, fQueue);
                    fQueue.start();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

