/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.queue;

import cn.hserver.core.context.IocApplicationContext;
import cn.hserver.core.queue.bean.QueueData;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueEventHandler {
    private static final Logger log = LoggerFactory.getLogger(QueueEventHandler.class);
    private final Method method;
    private final String handlerName;
    private Object handler;

    public QueueEventHandler(String handlerName, Method method) {
        this.method = method;
        this.handlerName = handlerName;
    }

    public void invoke(QueueData queueData) {
        try {
            if (this.handler == null) {
                this.handler = IocApplicationContext.getBean(this.handlerName);
            }
            Object[] args = queueData.getArgs();
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            this.method.invoke(this.handler, args);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

