/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.plugin.bean;

public class PluginInfo {
    private String name;
    private String version;
    private String author;
    private String description;

    public PluginInfo() {
    }

    public PluginInfo(String name, String version, String author, String description) {
        this.name = name;
        this.version = version;
        this.author = author;
        this.description = description;
    }

    private PluginInfo(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.author = builder.author;
        this.description = builder.description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String info() {
        if (this.name == null) {
            return null;
        }
        String separator = "==========================================";
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("\n").append(separator).append("\n").append("\u3010").append(this.name).append("\u3011\n");
        logBuilder.append(String.format("\u540d\u79f0\t: %s\n", this.name));
        if (this.version != null && !this.version.isEmpty()) {
            logBuilder.append(String.format("\u7248\u672c\t: %s\n", this.version));
        }
        if (this.author != null && !this.author.isEmpty()) {
            logBuilder.append(String.format("\u4f5c\u8005\t: %s\n", this.author));
        }
        if (this.description != null && !this.description.isEmpty()) {
            logBuilder.append(String.format("\u63cf\u8ff0\t: %s\n", this.description));
        }
        logBuilder.append(separator).append("\n");
        return logBuilder.toString();
    }

    public static class Builder {
        private String name;
        private String version;
        private String author;
        private String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public PluginInfo build() {
            return new PluginInfo(this);
        }
    }
}

