/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.plugin;

import cn.hserver.core.plugin.bean.PluginInfo;
import cn.hserver.core.plugin.handler.PluginAdapter;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;

public class PluginManager
extends PluginAdapter {
    private final Set<String> plugPackages = new HashSet<String>();
    private final Set<PluginAdapter> obj = new HashSet<PluginAdapter>();
    private static final PluginManager PLUGS_MANAGER = new PluginManager();

    public static PluginManager getPlugin() {
        return PLUGS_MANAGER;
    }

    private PluginManager() {
        ServiceLoader<PluginAdapter> loadedParsers = ServiceLoader.load(PluginAdapter.class);
        for (PluginAdapter pluginAdapter : loadedParsers) {
            this.obj.add(pluginAdapter);
            Set<String> strings = pluginAdapter.extScanPackages();
            if (strings != null) {
                this.plugPackages.addAll(strings);
            }
            this.plugPackages.add(pluginAdapter.getClass().getPackage().getName());
        }
    }

    public Set<String> getPlugPackages() {
        return this.plugPackages;
    }

    @Override
    public void startedApp() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.startedApp();
        }
    }

    @Override
    public void iocStartScan(Class<?> clazz) {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.iocStartScan(clazz);
        }
    }

    @Override
    public void iocStartRegister() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.iocStartRegister();
        }
    }

    @Override
    public void iocStartPopulate() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.iocStartPopulate();
        }
    }

    @Override
    public void startApp() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.startApp();
        }
    }

    public void pluginInfo() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.printPluginInfo();
        }
    }

    @Override
    public PluginInfo getPluginInfo() {
        return null;
    }
}

