/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import cn.hserver.core.config.ConstConfig;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public class HServerLogConfig {
    public static void init() {
        try {
            HServerLogConfig.loadConfiguration(HServerLogConfig.class.getResourceAsStream("/" + ConstConfig.LOGBACK_NAME));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static void stopAndReset(LoggerContext loggerContext) {
        loggerContext.stop();
        loggerContext.reset();
    }

    private static void loadConfiguration(InputStream in) throws Exception {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        HServerLogConfig.stopAndReset(loggerContext);
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        configurator.doConfigure(in);
        in.close();
        Logger root = loggerContext.getLogger("ROOT");
        if (root != null) {
            root.setLevel(Level.toLevel((String)ConstConfig.LOG_LEVEL));
        }
    }
}

