/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.ioc.handler;

import cn.hserver.core.ioc.handler.AutowiredHandler;
import cn.hserver.core.ioc.handler.ConfigurationPropertiesHandler;
import cn.hserver.core.ioc.handler.ValueHandler;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public interface PopulateBeanHandler {
    public static final List<PopulateBeanHandler> HANDLERS = new ArrayList<PopulateBeanHandler>(){
        {
            this.add(new ConfigurationPropertiesHandler());
            this.add(new AutowiredHandler());
            this.add(new ValueHandler());
        }
    };

    public static void addHandler(PopulateBeanHandler handler) {
        HANDLERS.add(handler);
    }

    public void populate(Object var1);

    default public boolean populateValue(Object beanInstance, Field field, Object fieldValue) {
        try {
            try {
                PropertyDescriptor[] propertyDescriptors;
                BeanInfo beanInfo = Introspector.getBeanInfo(beanInstance.getClass());
                for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                    Method setterMethod;
                    if (!pd.getName().equals(field.getName()) || pd.getWriteMethod() == null || !Modifier.isPublic((setterMethod = pd.getWriteMethod()).getModifiers())) continue;
                    setterMethod.invoke(beanInstance, fieldValue);
                    return true;
                }
            }
            catch (Exception beanInfo) {
                // empty catch block
            }
            field.setAccessible(true);
            field.set(beanInstance, fieldValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

