/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.ioc;

import cn.hserver.core.aop.ProxyFactory;
import cn.hserver.core.ioc.annotation.Autowired;
import cn.hserver.core.ioc.annotation.Order;
import cn.hserver.core.ioc.annotation.PostConstruct;
import cn.hserver.core.ioc.annotation.Qualifier;
import cn.hserver.core.ioc.bean.BeanDefinition;
import cn.hserver.core.ioc.handler.PopulateBeanHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFactory {
    private static final Logger log = LoggerFactory.getLogger(BeanFactory.class);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>();
    private final Map<String, Object> refreshScopeCache = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> singletonObjects = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> earlySingletonObjects = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> singletonFactories = new ConcurrentHashMap<String, Object>();
    private final Set<String> singletonsCurrentlyInCreation = Collections.newSetFromMap(new ConcurrentHashMap());

    public Object getBean(String name) throws Exception {
        return this.doGetBean(name);
    }

    public void addBean(Object bean) {
        Class<?> clazz = bean.getClass();
        BeanDefinition beanDefinition = new BeanDefinition();
        beanDefinition.setBeanClass(clazz);
        this.beanDefinitionMap.put(beanDefinition.getDefaultBeanName(), beanDefinition);
        this.singletonObjects.put(beanDefinition.getDefaultBeanName(), bean);
    }

    public void addBean(String beanName, Object bean) {
        Class<?> clazz = bean.getClass();
        BeanDefinition beanDefinition = new BeanDefinition();
        beanDefinition.setBeanClass(clazz);
        this.beanDefinitionMap.put(beanName, beanDefinition);
        this.singletonObjects.put(beanName, bean);
    }

    private <T> List<T> sortByOrder(List<T> beans) {
        return beans.stream().sorted((bean1, bean2) -> {
            int order1 = this.getOrderValue(bean1.getClass());
            int order2 = this.getOrderValue(bean2.getClass());
            return Integer.compare(order1, order2);
        }).collect(Collectors.toList());
    }

    private int getOrderValue(Class<?> clazz) {
        Order orderAnnotation = clazz.getAnnotation(Order.class);
        return orderAnnotation != null ? orderAnnotation.value() : Integer.MAX_VALUE;
    }

    public <T> List<T> getBeansOfType(Class<T> type, boolean sorted) {
        ArrayList<T> beans = new ArrayList<T>();
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getBeanClass())) continue;
            try {
                beans.add(type.cast(this.getBean(entry.getKey())));
            }
            catch (Exception exception) {}
        }
        if (sorted) {
            return this.sortByOrder(beans);
        }
        return beans;
    }

    public <T> T getBean(Class<T> requiredType) throws Exception {
        ArrayList<String> beanNames = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
            if (!requiredType.isAssignableFrom(entry.getValue().getBeanClass())) continue;
            beanNames.add(entry.getKey());
            break;
        }
        if (beanNames.isEmpty()) {
            throw new IllegalArgumentException("No qualifying bean of type '" + requiredType.getName() + "' found");
        }
        return requiredType.cast(this.getBean((String)beanNames.get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetBean(String name) throws Exception {
        BeanDefinition beanDefinition;
        Object sharedInstance = this.singletonObjects.get(name);
        if (sharedInstance != null) {
            return (T)sharedInstance;
        }
        if (this.singletonsCurrentlyInCreation.contains(name)) {
            sharedInstance = this.earlySingletonObjects.get(name);
            if (sharedInstance != null) {
                return (T)sharedInstance;
            }
            Object object = this.singletonFactories.get(name);
            if (object != null) {
                sharedInstance = object;
                this.earlySingletonObjects.put(name, sharedInstance);
                this.singletonFactories.remove(name);
                return (T)sharedInstance;
            }
        }
        if ((beanDefinition = this.beanDefinitionMap.get(name)) == null) {
            throw new IllegalArgumentException("No bean named '" + name + "' found");
        }
        if (beanDefinition.isSingleton() || beanDefinition.isRefresh()) {
            Map<String, Object> map = this.singletonObjects;
            synchronized (map) {
                sharedInstance = this.singletonObjects.get(name);
                if (sharedInstance == null) {
                    this.singletonsCurrentlyInCreation.add(name);
                    try {
                        Object beanInstance = this.createBean(beanDefinition, false);
                        this.singletonFactories.put(name, beanInstance);
                        this.populateBean(beanInstance);
                        if (!this.singletonObjects.containsKey(name)) {
                            this.initializeBean(beanInstance);
                        }
                        this.singletonObjects.put(name, beanInstance);
                        this.earlySingletonObjects.remove(name);
                        this.singletonFactories.remove(name);
                        this.singletonsCurrentlyInCreation.remove(name);
                        return (T)beanInstance;
                    }
                    catch (Exception ex) {
                        this.singletonsCurrentlyInCreation.remove(name);
                        throw ex;
                    }
                }
            }
        } else {
            if (beanDefinition.isPrototype()) {
                Object prototypeInstance = this.createBean(beanDefinition, false);
                this.initializeBean(prototypeInstance);
                return (T)prototypeInstance;
            }
            throw new IllegalArgumentException("Unsupported scope: " + (Object)((Object)beanDefinition.getScope()));
        }
        return (T)sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrCreateRefreshTarget(BeanDefinition beanDefinition) throws Exception {
        Map<String, Object> map = this.refreshScopeCache;
        synchronized (map) {
            Object target = this.refreshScopeCache.get(beanDefinition.getDefaultBeanName());
            if (target == null) {
                if (beanDefinition.getFactoryMethod() != null) {
                    Object factoryBean = this.getBean(beanDefinition.getFactoryBeanName());
                    Method factoryMethod = beanDefinition.getFactoryMethod();
                    Object[] args = this.resolveMethodArguments(factoryMethod);
                    target = factoryMethod.invoke(factoryBean, args);
                } else {
                    target = this.createBean(beanDefinition, true);
                }
                this.populateBean(target);
                this.initializeBean(target);
                this.refreshScopeCache.put(beanDefinition.getDefaultBeanName(), target);
            }
            return target;
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        this.beanDefinitionMap.put(beanName, beanDefinition);
    }

    private Object createBean(BeanDefinition beanDefinition, boolean real) throws Exception {
        if (beanDefinition.getFactoryMethod() != null) {
            Object factoryBean = this.getBean(beanDefinition.getFactoryBeanName());
            Method factoryMethod = beanDefinition.getFactoryMethod();
            Object[] args = this.resolveMethodArguments(factoryMethod);
            if (beanDefinition.isRefresh() && !real) {
                Constructor<?> constructor = beanDefinition.getConstructor();
                return ProxyFactory.newRefreshProxyInstance(beanDefinition, beanDefinition.getConstructor(), new Object[constructor.getParameterTypes().length]);
            }
            return factoryMethod.invoke(factoryBean, args);
        }
        Class<?> beanClass = beanDefinition.getBeanClass();
        Constructor<?> constructorToUse = beanDefinition.getConstructor();
        if (constructorToUse == null) {
            Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
            Constructor<?> autowiredConstructor = null;
            for (Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(Autowired.class)) continue;
                if (autowiredConstructor != null) {
                    throw new IllegalArgumentException("Multiple constructors with @Autowired found in " + beanClass);
                }
                autowiredConstructor = constructor;
            }
            constructorToUse = autowiredConstructor != null ? autowiredConstructor : constructors[0];
        }
        Object[] args = this.resolveConstructorArguments(constructorToUse);
        Object beanInstance = beanDefinition.isHook() && !real ? ProxyFactory.newHookProxyInstance(beanDefinition, constructorToUse, args) : (beanDefinition.isRefresh() && !real ? ProxyFactory.newRefreshProxyInstance(beanDefinition, constructorToUse, args) : constructorToUse.newInstance(args));
        beanDefinition.setConstructor(constructorToUse);
        return beanInstance;
    }

    private void populateBean(Object beanInstance) throws Exception {
        for (PopulateBeanHandler handler : PopulateBeanHandler.HANDLERS) {
            handler.populate(beanInstance);
        }
    }

    private Object[] resolveConstructorArguments(Constructor<?> constructor) throws Exception {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                Class<?> parameterType = parameterTypes[i];
                String beanName = null;
                Parameter parameter = constructor.getParameters()[i];
                Qualifier qualifier = parameter.getAnnotation(Qualifier.class);
                if (qualifier != null) {
                    beanName = qualifier.value();
                }
                if (beanName != null) {
                    args[i] = this.getBean(beanName);
                    continue;
                }
                args[i] = this.getBean(parameterType);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return args;
    }

    private Object[] resolveMethodArguments(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                Class<?> parameterType = parameterTypes[i];
                String beanName = null;
                Parameter parameter = method.getParameters()[i];
                Qualifier qualifier = parameter.getAnnotation(Qualifier.class);
                if (qualifier != null) {
                    beanName = qualifier.value();
                }
                if (beanName != null) {
                    args[i] = this.getBean(beanName);
                    continue;
                }
                args[i] = this.getBean(parameterType);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return args;
    }

    private void initializeBean(Object beanInstance) throws Exception {
        Class<?> beanClass = beanInstance.getClass();
        Method postConstructMethod = null;
        for (Method method : beanClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstructMethod != null) {
                throw new IllegalStateException("Multiple @PostConstruct methods found in " + beanClass.getName());
            }
            if (method.getParameterCount() != 0) {
                throw new IllegalArgumentException("@PostConstruct method " + method.getName() + " must have no parameters");
            }
            postConstructMethod = method;
        }
        if (postConstructMethod != null) {
            postConstructMethod.setAccessible(true);
            postConstructMethod.invoke(beanInstance, new Object[0]);
        }
    }

    public void clearRefreshScope() {
        this.refreshScopeCache.clear();
    }
}

