/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.context.handler;

import cn.hserver.core.context.handler.AnnotationHandler;
import cn.hserver.core.ioc.bean.BeanDefinition;
import cn.hserver.core.queue.QueueEventHandler;
import cn.hserver.core.queue.QueueManager;
import cn.hserver.core.queue.annotation.QueueHandler;
import cn.hserver.core.queue.annotation.QueueListener;
import cn.hserver.core.queue.bean.QueueHandleInfo;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueListenerHandler
implements AnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(QueueListenerHandler.class);

    @Override
    public void handle(Class<?> clazz, Map<String, BeanDefinition> beanDefinitions) {
        String className = clazz.getName();
        if (clazz.isAnnotationPresent(QueueListener.class)) {
            BeanDefinition configBeanDef = new BeanDefinition();
            configBeanDef.setBeanClass(clazz);
            QueueListener queueListener = clazz.getAnnotation(QueueListener.class);
            for (Method declaredMethod : clazz.getDeclaredMethods()) {
                if (!declaredMethod.isAnnotationPresent(QueueHandler.class)) continue;
                QueueHandleInfo eventHandleInfo = new QueueHandleInfo(queueListener.queueName());
                eventHandleInfo.setThreadSize(queueListener.threadSize());
                eventHandleInfo.setQueueEventHandler(new QueueEventHandler(configBeanDef.getDefaultBeanName(), declaredMethod));
                QueueManager.addQueueListener(eventHandleInfo);
                beanDefinitions.put(configBeanDef.getDefaultBeanName(), configBeanDef);
                log.debug("\u5bfb\u627e\u961f\u5217 [{}] \u7684\u65b9\u6cd5 [{}.{}]", new Object[]{queueListener.queueName(), clazz.getSimpleName(), declaredMethod.getName()});
                return;
            }
        }
    }
}

