/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.context.handler;

import cn.hserver.core.config.annotation.Configuration;
import cn.hserver.core.config.annotation.ConfigurationProperties;
import cn.hserver.core.context.handler.AnnotationHandler;
import cn.hserver.core.ioc.annotation.Bean;
import cn.hserver.core.ioc.annotation.Scope;
import cn.hserver.core.ioc.bean.BeanDefinition;
import java.lang.reflect.Method;
import java.util.Map;

public class ConfigurationHandler
implements AnnotationHandler {
    @Override
    public void handle(Class<?> clazz, Map<String, BeanDefinition> beanDefinitions) {
        if (clazz.isAnnotationPresent(Configuration.class)) {
            Configuration config = clazz.getAnnotation(Configuration.class);
            BeanDefinition configBeanDef = new BeanDefinition();
            configBeanDef.setBeanClass(clazz);
            String configBeanName = config.value();
            if (configBeanName.isEmpty()) {
                configBeanName = configBeanDef.getDefaultBeanName();
            }
            if (clazz.isAnnotationPresent(Scope.class)) {
                Scope scope = clazz.getAnnotation(Scope.class);
                configBeanDef.setScope(scope.value());
            }
            beanDefinitions.put(configBeanName, configBeanDef);
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Bean.class)) continue;
                Bean bean = method.getAnnotation(Bean.class);
                String beanName = bean.value();
                if (beanName.isEmpty()) {
                    beanName = method.getName();
                }
                BeanDefinition beanDef = new BeanDefinition();
                beanDef.setConstructor(method.getReturnType().getConstructors()[0]);
                beanDef.setBeanClass(method.getReturnType());
                beanDef.setFactoryBeanName(configBeanName);
                beanDef.setFactoryMethod(method);
                if (method.isAnnotationPresent(Scope.class)) {
                    Scope scope = method.getAnnotation(Scope.class);
                    beanDef.setScope(scope.value());
                }
                beanDefinitions.put(beanName, beanDef);
            }
        }
        if (clazz.isAnnotationPresent(ConfigurationProperties.class)) {
            BeanDefinition configBeanDef = new BeanDefinition();
            configBeanDef.setBeanClass(clazz);
            beanDefinitions.put(configBeanDef.getDefaultBeanName(), configBeanDef);
        }
    }
}

