/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.context;

import cn.hserver.core.aop.HookFactory;
import cn.hserver.core.context.handler.AnnotationHandler;
import cn.hserver.core.ioc.BeanFactory;
import cn.hserver.core.ioc.bean.BeanDefinition;
import cn.hserver.core.plugin.PluginManager;
import cn.hserver.core.util.ClassLoadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IocApplicationContext {
    private static final BeanFactory beanFactory = new BeanFactory();
    private final Map<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();

    public IocApplicationContext(Set<String> basePackages) {
        basePackages.forEach(this::scan);
        HookFactory.handlerHookData(this.beanDefinitions);
        PluginManager.getPlugin().iocStartRegister();
        this.registerBeanDefinition();
        PluginManager.getPlugin().iocStartPopulate();
        this.refresh();
    }

    public static void addBean(Object obj) {
        beanFactory.addBean(obj);
    }

    public static void addBean(String beanName, Object obj) {
        beanFactory.addBean(beanName, obj);
    }

    private void scan(String basePackage) {
        ClassLoadUtil.loadClasses(basePackage, false).forEach(this::processClass);
    }

    private void processClass(Class<?> clazz) {
        AnnotationHandler.ANNOTATION_HANDLERS.forEach(handler -> handler.handle(clazz, this.beanDefinitions));
        PluginManager.getPlugin().iocStartScan(clazz);
    }

    private void registerBeanDefinition() {
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitions.entrySet()) {
            beanFactory.registerBeanDefinition(entry.getKey(), entry.getValue());
        }
    }

    private void refresh() {
        for (String beanName : this.beanDefinitions.keySet()) {
            BeanDefinition beanDefinition = this.beanDefinitions.get(beanName);
            if (!beanDefinition.isSingleton()) continue;
            try {
                beanFactory.getBean(beanName);
            }
            catch (Exception e) {
                throw new RuntimeException("\u521d\u59cb\u5316\u5355\u4f8bBean\u5931\u8d25\uff1a" + beanName, e);
            }
        }
    }

    public static Object getBean(String name) {
        try {
            return beanFactory.getBean(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getBean(Class<T> requiredType) {
        try {
            return beanFactory.getBean(requiredType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> List<T> getBeansOfType(Class<T> requiredType) {
        return beanFactory.getBeansOfType(requiredType, false);
    }

    public static <T> T getBeansOfTypeOne(Class<T> requiredType) {
        List<T> beansOfType = beanFactory.getBeansOfType(requiredType, false);
        if (!beansOfType.isEmpty()) {
            return beansOfType.get(0);
        }
        return null;
    }

    public static <T> List<T> getBeansOfTypeSorted(Class<T> requiredType) {
        return beanFactory.getBeansOfType(requiredType, true);
    }

    public static <T> T getOrCreateRefreshTarget(BeanDefinition beanDefinition) {
        try {
            return (T)beanFactory.getOrCreateRefreshTarget(beanDefinition);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearRefreshScope() {
        beanFactory.clearRefreshScope();
    }
}

