/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.config;

import cn.hserver.core.config.ConfigMap;
import cn.hserver.core.config.ConstConfig;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.yaml.snakeyaml.Yaml;

public class ConfigData {
    private static final ConfigMap configMap = new ConfigMap();
    private static final ConfigData reader = new ConfigData();

    public static ConfigData getInstance() {
        return reader;
    }

    private ConfigData() {
        this.loadConfig("app");
        Object env = configMap.get("env");
        if (env != null && !env.toString().isEmpty()) {
            ConstConfig.EVN = env.toString();
        }
        if (ConstConfig.EVN != null) {
            this.loadConfig("app-" + ConstConfig.EVN);
        }
    }

    private void loadConfig(String name) {
        this.loadYamlConfig(name + ".yaml");
        this.loadYamlConfig(name + ".yml");
        this.loadPropertiesConfig(name + ".properties");
    }

    private void loadYamlConfig(String name) {
        try (InputStreamReader inputStream = this.loadFileStream(name);){
            Yaml yaml = new Yaml();
            Map yamlMap = (Map)yaml.load((Reader)inputStream);
            if (yamlMap != null) {
                this.flattenMap(yamlMap, "", configMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadPropertiesConfig(String name) {
        try (InputStreamReader inputStream = this.loadFileStream(name);){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> configMap.put(key.toString(), value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStreamReader loadFileStream(String name) {
        try {
            return new InputStreamReader(Files.newInputStream(Paths.get(ConstConfig.PATH + name, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            try {
                return new InputStreamReader(Objects.requireNonNull(ConstConfig.class.getResourceAsStream("/" + name)), StandardCharsets.UTF_8);
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    private void flattenMap(Map<String, Object> source, String prefix, Map<String, Object> target) {
        source.forEach((key, value) -> {
            String newKey;
            String string = newKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                this.flattenMap(nestedMap, newKey, target);
            } else {
                target.put(newKey, value);
            }
        });
    }

    public Map<String, Object> getConfigMap() {
        return new HashMap<String, Object>(configMap);
    }

    public Object get(String key) {
        return configMap.get(key);
    }

    public void set(String key, Object value) {
        configMap.put(key, value);
    }

    public Object get(String key, Object defaultValue) {
        return configMap.getOrDefault(key, defaultValue);
    }

    public String getString(String key) {
        return this.getAndConvert(key, Object::toString);
    }

    public String getString(String key, String defaultValue) {
        return this.getAndConvert(key, Object::toString, defaultValue);
    }

    public Integer getInteger(String key) {
        return this.getAndConvert(key, Integer::valueOf);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.getAndConvert(key, Integer::valueOf, defaultValue);
    }

    public Long getLong(String key) {
        return this.getAndConvert(key, Long::valueOf);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.getAndConvert(key, Long::valueOf, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.getAndConvert(key, Boolean::valueOf);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getAndConvert(key, Boolean::valueOf, defaultValue);
    }

    private <T> T getAndConvert(String key, Function<String, T> converter) {
        Object value = configMap.get(key);
        if (value == null) {
            return null;
        }
        return converter.apply(value.toString());
    }

    private <T> T getAndConvert(String key, Function<String, T> converter, T defaultValue) {
        T value = this.getAndConvert(key, converter);
        return value != null ? value : defaultValue;
    }
}

