/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.core.boot;

import cn.hserver.core.config.ConfigData;
import cn.hserver.core.context.IocApplicationContext;
import cn.hserver.core.life.CloseAdapter;
import cn.hserver.core.life.InitAdapter;
import cn.hserver.core.life.StartAdapter;
import cn.hserver.core.logging.HServerLogAsyncAppender;
import cn.hserver.core.logging.HServerLogConfig;
import cn.hserver.core.logging.LogAdapter;
import cn.hserver.core.plugin.PluginManager;
import cn.hserver.core.queue.QueueManager;
import cn.hserver.core.scheduling.TaskManager;
import cn.hserver.core.util.EnvironmentUtil;
import cn.hserver.core.util.NamedThreadFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HServerApplication {
    private static final Logger log = LoggerFactory.getLogger(HServerApplication.class);
    private static final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static boolean running = false;
    private static Class<?> mainClass;

    public static synchronized void run(Class<?> mainClass, String ... args) {
        HServerApplication.runCore(mainClass, null, args);
    }

    public static synchronized void runTest(Class<?> testClass) {
        HServerApplication.runCore(null, testClass, new String[0]);
    }

    private static synchronized void runCore(Class<?> mainClass, Class<?> testClass, String ... args) {
        if (!running) {
            running = true;
            HServerApplication.mainClass = mainClass;
            PluginManager.getPlugin().startApp();
            ConfigData.getInstance();
            EnvironmentUtil.init(testClass);
            HServerLogConfig.init();
            Set<String> plugPackages = PluginManager.getPlugin().getPlugPackages();
            if (testClass != null) {
                plugPackages.add(testClass.getPackage().getName());
            }
            new IocApplicationContext(HServerApplication.packages(plugPackages));
            QueueManager.startQueueServer();
            TaskManager.startTask();
            PluginManager.getPlugin().startedApp();
            HServerApplication.success(args);
            try {
                if (testClass == null) {
                    shutdownLatch.await();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            log.info("HServer\u5df2\u542f\u52a8");
        }
    }

    public static void stop() {
        if (running) {
            shutdownLatch.countDown();
        }
    }

    private static Set<String> packages(Set<String> testPackageName) {
        HashSet<String> scanPackage = new HashSet<String>();
        if (testPackageName != null) {
            scanPackage.addAll(testPackageName);
        }
        if (mainClass != null) {
            scanPackage.add(mainClass.getPackage().getName());
        }
        scanPackage.add(HServerApplication.class.getPackage().getName());
        return scanPackage;
    }

    private static void success(String[] args) {
        PluginManager.getPlugin().pluginInfo();
        IocApplicationContext.getBeansOfType(InitAdapter.class).forEach(initAdapter -> {
            try {
                initAdapter.init(args);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        });
        log.info("HServer\u542f\u52a8\u6210\u529f");
        HServerLogAsyncAppender.setHasLog(IocApplicationContext.getBeansOfType(LogAdapter.class));
        IocApplicationContext.getBeansOfType(StartAdapter.class).forEach(startAdapter -> {
            try {
                startAdapter.start();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    static {
        Thread shutdown = new NamedThreadFactory("hserver_shutdown").newThread(() -> {
            log.info("\u670d\u52a1\u5373\u5c06\u5173\u95ed");
            List<CloseAdapter> beansOfType = IocApplicationContext.getBeansOfType(CloseAdapter.class);
            for (CloseAdapter closeAdapter : beansOfType) {
                try {
                    closeAdapter.close();
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
            log.info("\u670d\u52a1\u5173\u95ed\u5b8c\u6210");
        });
        Runtime.getRuntime().addShutdownHook(shutdown);
    }
}

