/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.spring.transaction;

import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringNbTransaction
implements INbTransaction {
    private static final Logger log = LoggerFactory.getLogger(SpringNbTransaction.class);
    private final boolean closeConnection;
    private Connection connection;
    private INbDataSource dataSource;
    private boolean autoCommit;
    private boolean isConnectionTransactional;

    public SpringNbTransaction(Connection conn) {
        this.connection = conn;
        this.closeConnection = false;
    }

    public SpringNbTransaction(INbDataSource nbDataSource) {
        this.closeConnection = true;
        this.dataSource = nbDataSource;
    }

    public Connection getConnection(String dsName) throws SQLException {
        if (this.connection == null) {
            this.openConnection(dsName);
        }
        return this.connection;
    }

    private void openConnection(String dsName) throws SQLException {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)this.dataSource.getAll()), (String)"\u672a\u914d\u7f6e\u6570\u636e\u6e90,\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object[])new Object[0]);
        this.connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        this.autoCommit = this.connection.getAutoCommit();
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.connection, (DataSource)this.dataSource);
        if (log.isDebugEnabled()) {
            log.debug("JDBC Connection [" + this.connection + "] will" + (this.isConnectionTransactional ? " " : " not ") + "be managed by Spring");
        }
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (log.isDebugEnabled()) {
                log.debug("Committing JDBC Connection [" + this.connection + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (log.isDebugEnabled()) {
                log.debug("Rolling back JDBC Connection [" + this.connection + "]");
            }
            this.connection.rollback();
        }
    }

    public void close() {
        if (this.closeConnection) {
            DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)this.dataSource);
        }
    }
}

