/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.spring.mapper;

import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import cn.hperfect.nbquerier.spring.mapper.ClassPathMapperScanner;
import cn.hperfect.nbquerier.spring.mapper.MapperFactoryBean;
import java.lang.annotation.Annotation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MapperScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String beanName;
    private String basePackage;
    private Class<? extends Annotation> annotationClass;
    private Class<? extends MapperFactoryBean> mapperFactoryBeanClass;
    private ApplicationContext applicationContext;
    private ISqlMapperBuilder sqlMapperBuilder;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
        Assert.notNull((Object)this.sqlMapperBuilder, (String)"Property 'sqlMapperBuilder' is required");
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        scanner.setMapperFactoryBeanClass(this.mapperFactoryBeanClass);
        scanner.setAnnotationClass(this.annotationClass);
        scanner.setSqlMapperBuilder(this.sqlMapperBuilder);
        scanner.registerFilters();
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public Class<? extends MapperFactoryBean> getMapperFactoryBeanClass() {
        return this.mapperFactoryBeanClass;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ISqlMapperBuilder getSqlMapperBuilder() {
        return this.sqlMapperBuilder;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setMapperFactoryBeanClass(Class<? extends MapperFactoryBean> mapperFactoryBeanClass) {
        this.mapperFactoryBeanClass = mapperFactoryBeanClass;
    }

    public void setSqlMapperBuilder(ISqlMapperBuilder sqlMapperBuilder) {
        this.sqlMapperBuilder = sqlMapperBuilder;
    }
}

