/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.datasouce;

import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.ds.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.exception.CannotFindDataSourceException;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NbDataSource
extends AbstractRoutingDataSource
implements INbDataSource,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NbDataSource.class);
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private DynamicDataSourceProvider provider;
    private DataSource master;

    public NbDataSource(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }

    public DataSource switchDataSource(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return this.determineDataSource();
        }
        DataSource dataSource = this.dataSourceMap.get(name);
        Assert.notNull((Object)dataSource, (String)"\u6570\u636e\u6e90:{}\u4e0d\u5b58\u5728", (Object[])new Object[]{name});
        return dataSource;
    }

    public DbType getDbType(String name) {
        return null;
    }

    public Collection<DataSource> getAll() {
        return this.dataSourceMap.values();
    }

    protected DataSource determineDataSource() {
        String ds = DynamicDataSourceContextHolder.peek();
        if (StrUtil.isBlank((CharSequence)ds)) {
            return this.master;
        }
        if (this.dataSourceMap.containsKey(ds)) {
            log.debug("dynamic-datasource switch to the datasource named [{}]", (Object)ds);
            return this.dataSourceMap.get(ds);
        }
        throw new CannotFindDataSourceException("dynamic-datasource could not find a datasource named:" + ds);
    }

    public void afterPropertiesSet() throws Exception {
        Map dataSources = this.provider.loadDataSources();
        for (Map.Entry dsItem : dataSources.entrySet()) {
            this.addDataSource((String)dsItem.getKey(), (DataSource)dsItem.getValue());
        }
        Assert.notNull((Object)this.master, (String)"\u4e3b\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void destroy() throws Exception {
        log.info("dynamic-datasource start closing ....");
        for (Map.Entry<String, DataSource> item : this.dataSourceMap.entrySet()) {
            this.closeDataSource(item.getKey(), item.getValue());
        }
        log.info("dynamic-datasource all closed success,bye");
    }

    private void closeDataSource(String name, DataSource dataSource) throws InvocationTargetException, IllegalAccessException {
        Class<?> clazz = dataSource.getClass();
        try {
            Method closeMethod = clazz.getDeclaredMethod("close", new Class[0]);
            closeMethod.invoke((Object)dataSource, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.warn("dynamic-datasource close the datasource named [{}] failed,", (Object)name);
        }
    }

    public synchronized void addDataSource(String ds, DataSource dataSource) {
        if (!this.dataSourceMap.containsKey(ds)) {
            this.dataSourceMap.put(ds, dataSource);
            if (ds.equals("master")) {
                this.master = dataSource;
            }
            log.info("dynamic-datasource - load a datasource named [{}] success", (Object)ds);
        } else {
            log.warn("dynamic-datasource - load a datasource named [{}] failed, because it already exist", (Object)ds);
        }
    }

    public void setProvider(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }
}

