/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.NbExecutorFactory;
import cn.hperfect.nbquerier.config.NbQuerierConfigFactory;
import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.datasouce.NbDataSource;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.SnowflakeIdApplier;
import cn.hperfect.nbquerier.core.components.route.ISchemaRoute;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import cn.hperfect.nbquerier.spring.transaction.SpringTransactionFactory;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@Import(value={SpringUtil.class})
@EnableTransactionManagement
@EnableConfigurationProperties(value={NbQuerierProperties.class})
public class NbQuerierAutoConfiguration {
    private final NbQuerierConfiguration configuration;

    @Bean
    public NbQuerierConfiguration nbQuerierConfiguration() {
        return this.configuration;
    }

    public NbQuerierAutoConfiguration(NbQuerierProperties nbQuerierProperties, INbDataSource dataSource, SnowflakeIdApplier snowflakeIdApplier, @Autowired(required=false) ISqlMapperBuilder sqlMapperBuilder, ITransactionFactory transactionFactory, @Autowired(required=false) ISchemaRoute schemaRoute) {
        this.configuration = NbQuerierConfigFactory.INSTANCE.init(nbQuerierProperties, transactionFactory, dataSource);
        this.configuration.setSqlMapperBuilder(sqlMapperBuilder);
        this.configuration.getFieldFillStrategyRegistry().init(snowflakeIdApplier);
        this.configuration.setSchemaRoute(schemaRoute);
    }

    @Bean
    NbExecutorFactory nbExecutorFactory() {
        return new NbExecutorFactory(this.configuration);
    }

    @Bean
    FieldFillStrategyRegistry fieldFillStrategyRegistry() {
        return this.configuration.getFieldFillStrategyRegistry();
    }

    @Bean
    public ValidatorRegistry validatorRegistry() {
        return this.configuration.getValidatorRegistry();
    }

    @Bean
    NbInterceptorRegistry nbInterceptorRegistry() {
        return this.configuration.getNbInterceptorRegistry();
    }

    @Bean
    public INbQueryBuilder nbQueryBuilder() {
        return this.configuration.getNbQueryBuilder();
    }

    @Configuration
    public static class DataAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ITransactionFactory transactionFactory() {
            return new SpringTransactionFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public INbDataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
            return new NbDataSource(dynamicDataSourceProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        public Snowflake snowflake(NbQuerierProperties nbQuerierProperties) {
            return new Snowflake(nbQuerierProperties.getWorkerId().longValue(), nbQuerierProperties.getDataCenterId().longValue());
        }

        @Bean
        @ConditionalOnMissingBean
        public SnowflakeIdApplier snowIdApplier(Snowflake snowflake) {
            return new SnowflakeIdApplier(snowflake);
        }
    }
}

