package cn.hperfect.nbquerier.spring.mapper;

import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import lombok.Setter;
import org.springframework.beans.factory.FactoryBean;

public class MapperFactoryBean<T> implements FactoryBean<T> {
    private Class<T> mapperInterface;

    @Setter
    private ISqlMapperBuilder sqlMapperBuilder;

    public MapperFactoryBean() {
        // intentionally empty
    }
    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }
    @Override
    public T getObject() throws Exception {
        return sqlMapperBuilder.getMapper(mapperInterface);
    }

    @Override
    public Class<?> getObjectType() {
        return this.mapperInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
