package cn.hperfect.nbquerier.spring.annotation;

import cn.hperfect.nbquerier.annotation.SqlMapper;
import cn.hperfect.nbquerier.session.impl.DefaultNbSqlBuilder;
import cn.hperfect.nbquerier.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

/**
 * 扫描器注册器
 */
public class MapperScannerRegistrar implements ImportBeanDefinitionRegistrar, ResourceLoaderAware {


    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        //批量注册
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes
                .fromMap(importingClassMetadata.getAnnotationAttributes(SqlMapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            String s = generateBaseBeanName(importingClassMetadata, 0);
            registerBeanDefinitions(importingClassMetadata, mapperScanAttrs, registry, s);
        }
    }

    void registerBeanDefinitions(AnnotationMetadata annoMeta, AnnotationAttributes annoAttrs,
                                 BeanDefinitionRegistry registry, String beanName) {

        //注册 sqlMapperBuilder todo 判断是否存在bean
        BeanDefinitionBuilder sqlMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultNbSqlBuilder.class);
        registry.registerBeanDefinition("sqlMapperBuilder", sqlMapperBuilder.getBeanDefinition());

        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        builder.addPropertyValue("basePackage", annoAttrs.get("value"));
        builder.addPropertyValue("annotationClass", SqlMapper.class);
        builder.addAutowiredProperty("sqlMapperBuilder");
        registry.registerBeanDefinition(MapperScannerConfigurer.class.getName(), builder.getBeanDefinition());

    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName() + "#" + MapperScannerRegistrar.class.getSimpleName() + "#" + index;
    }

    @Override
    @Deprecated
    public void setResourceLoader(ResourceLoader resourceLoader) {

    }

    static class RepeatingRegistrar extends MapperScannerRegistrar {
        /**
         * {@inheritDoc}
         */
        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes
                    .fromMap(importingClassMetadata.getAnnotationAttributes(SqlMapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                AnnotationAttributes[] annotations = mapperScansAttrs.getAnnotationArray("value");
                for (int i = 0; i < annotations.length; i++) {
                    registerBeanDefinitions(importingClassMetadata, annotations[i], registry,
                            generateBaseBeanName(importingClassMetadata, i));
                }
            }
        }
    }
}
